﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WK5.Core.Basis.Filter
{
    public class RmaVerlaufFilter : Filter
    {
        public int UserId { get; set; }
        public int RmaNummer { get; set; }
        public override string ToSqlQuery(FbController2 fbController)
        {
            sqlBuilder.AppendLine("SELECT * FROM RMA_VERLAUF WHERE 1 = 1");
            BuildQueryConditions(fbController);
            sqlBuilder.AppendLine(" ORDER BY RMVE_TIMESTAMP DESC");

            string sql = sqlBuilder.ToString();
            sqlBuilder.Clear();
            return sql;
        }

        protected override void BuildQueryConditions(FbController2 fbController)
        {
            if(!string.IsNullOrWhiteSpace(Suchbegriff))
            {
                sqlBuilder.AppendLine(" AND RMVE_A_TEXT LIKE @SUCHBEGRIFF");
                fbController.AddParameter("@SUCHBEGRIFF", $"%{Suchbegriff}%");
            }

            if(RmaNummer > 0)
            {
                sqlBuilder.AppendLine(" AND RMVE_N_RMA_NR = @RMVE_N_RMA_NR");
                fbController.AddParameter("@RMVE_N_RMA_NR", RmaNummer);
            }

            if(UserId > 0)
            {
                sqlBuilder.AppendLine(" AND RMVE_N_LASTUSER = @RMVE_N_LASTUSER");
                fbController.AddParameter("@RMVE_N_LASTUSER", UserId);
            }
        }
    }
}
