﻿using System;

namespace WK5.Core.Basis.Filter
{
    public class PreisgruppenFilter : Filter
    {
        public override string ToSqlQuery(FbController2 fbController)
        {
            sqlBuilder.Append("SELECT FIRST 30 * FROM PREISGRUPPE WHERE 1 = 1");
            BuildQueryConditions(fbController);

            string sql = sqlBuilder.ToString();
            sqlBuilder.Clear();
            return sql;
        }

        protected override void BuildQueryConditions(FbController2 fbController)
        {
            if (!String.IsNullOrWhiteSpace(Suchbegriff))
            {
                if (Suchbegriff.Length > 255)
                {
                    throw new ArgumentOutOfRangeException(nameof(Suchbegriff));
                }

                sqlBuilder.Append(@$" AND (
   CAST(UPPER(PRGR_A_BZEICH) AS VARCHAR(255)) LIKE @SUCHBEGRIFF
OR CAST(UPPER(PRGR_A_NR) AS VARCHAR(255)) LIKE @SUCHBEGRIFF)");
                fbController.AddParameter("@SUCHBEGRIFF", $"%{Suchbegriff}%");
            }
        }
    }
}
