﻿namespace WK5.Core.Basis.Filter
{
    /// <summary>
    /// Stellt einen Filter zum Suchen von Objekten dar, die mit einer Pagination gesplittet werden sollen. Diese Klasse ist Abstrakt.
    /// </summary>
    public abstract class PageFilter : Filter
    {
        private int _seite = 1;
        private int _limit = 30;

        public int Seite { get => _seite; set => _seite = value < 1 ? 1 : value; }
        public int Limit { get => _limit; set => _limit = value < 1 ? 1 : value; }
        /// <summary>
        /// Generiert das SQL, dass die Maxanzahl aller Ergebnisse abfragt.
        /// </summary>
        /// <param name="fbController"></param>
        /// <returns></returns>
        public abstract string ToCountQuery(FbController2 fbController);

    }
    /// <summary>
    /// <inheritdoc />
    /// <para>
    /// Zusätzlich kann ein Enum für einen vordefinierten Suchmodus definiert werden.
    /// </para>
    /// </summary>
    /// <typeparam name="T"></typeparam>
    public abstract class PageFilter<T> : PageFilter where T : System.Enum
    {
#nullable disable
        public T Option { get; set; }
#nullable enable
    }

}
