﻿using System;

namespace WK5.Core.Basis.Filter
{
    public class OhneBerechnungAuswertungFilter : Filter
    {
        public Zeitraum Zeitraum { get; set; }

        public OhneBerechnungAuswertungFilter()
        {
            Zeitraum = new Zeitraum(new DateTime(DateTime.Today.Year - 1, 1, 1), new DateTime(DateTime.Today.Year - 1, 12, 31));
        }
        public override string ToSqlQuery(FbController2 fbController)
        {
            sqlBuilder.AppendLine(@"SELECT 
BELE_N_NR, 
BELE_A_OHNE_BERECHNUNG_GRUND, 
BELE_A_ERLOESKONTO,
(SELECT BCNG_N_USER FROM BELEG_CHANGE WHERE BCNG_A_BELEGTYP = 'LS' AND BCNG_N_BELEGNR = BELE_N_NR AND BCNG_N_ART = 40) AS BCNG_N_USER,
(SELECT OUT_EK FROM GET_REALER_EK('LS', BELE_N_NR)) AS EK
FROM BELEGE 
WHERE BELE_A_TYP = 'LS' 
AND coalesce(BELE_N_NR_RE, 0 ) = 0    
AND BELE_D_DATE BETWEEN @START AND @ENDE
ORDER BY BELE_N_NR ASC");

            

            string sql = sqlBuilder.ToString();
            sqlBuilder.Clear();
            return sql;
        }

        protected override void BuildQueryConditions(FbController2 fbController)
        {
            throw new NotImplementedException();
        }
    }
}
