﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WK5.Core.Basis.Filter
{
    public class OffeneRechnungenFilter : Filter
    {
        public override string ToSqlQuery(FbController2 fbController)
        {
            sqlBuilder.Append(@"SELECT BELE_N_NR, BELE_A_KUNDENNR, BELE_A_NAME1 FROM BELEGE WHERE BELE_A_TYP = 'RE' AND BELE_L_BEZAHLT = 'N'");
            BuildQueryConditions(fbController);
            string sql = sqlBuilder.ToString();
            sqlBuilder.Clear();
            return sql;
        }

        protected override void BuildQueryConditions(FbController2 fbController)
        {
            if(!string.IsNullOrWhiteSpace(Suchbegriff))
            {
                sqlBuilder.Append(@" AND BELE_A_KUNDENNR
IN
(
    SELECT KUND_A_NR FROM KUNDEN WHERE
    (
        upper(coalesce(KUND_A_SELEKTION1, '')) = @SUCHBEGRIFF OR
        upper(coalesce(KUND_A_SELEKTION2, '')) = @SUCHBEGRIFF OR
        upper(coalesce(KUND_A_SELEKTION3, '')) = @SUCHBEGRIFF OR
        upper(coalesce(KUND_A_SELEKTION4, '')) = @SUCHBEGRIFF OR
        upper(coalesce(KUND_A_SELEKTION5, '')) = @SUCHBEGRIFF OR
        upper(coalesce(KUND_A_SELEKTION6, '')) = @SUCHBEGRIFF
    )
)");
                fbController.AddParameter("@SUCHBEGRIFF", Suchbegriff);
            }
        }
    }
}
