﻿namespace WK5.Core.Basis.Filter
{
    public class LieferscheinOhneBerechnungFilter : PageFilter
    {
        public bool ZeigeGenehmigte { get; set; }
        public override string ToCountQuery(FbController2 fbController)
        {

            sqlBuilder.Append(@$"SELECT COUNT(*) FROM BELEGE
LEFT JOIN KUNDEN on BELE_A_KUNDENNR = KUND_A_NR
WHERE 1 = 1");
            BuildQueryConditions(fbController);
            string sql = sqlBuilder.ToString();
            sqlBuilder.Clear();
            return sql;
        }

        public override string ToSqlQuery(FbController2 fbController)
        {
            sqlBuilder.Append(@$"SELECT FIRST {Limit} SKIP {(Seite - 1) * Limit}
BELE_N_NR, BELE_A_KUNDENNR, BELE_D_DATE, KUND_A_NAME1, BELE_N_BRUTTO, BELE_N_NR_RMA, WK5_BELE_L_OHNE_BERECHNUNG, BELE_A_OHNE_BERECHNUNG_GRUND
FROM BELEGE 
LEFT JOIN KUNDEN on BELEGE.bele_a_kundennr = KUNDEN.kund_a_nr 
WHERE 1 = 1");
            BuildQueryConditions(fbController);
            sqlBuilder.Append(" ORDER BY BELE_D_DATE DESC, BELE_N_NR DESC");
            string sql = sqlBuilder.ToString();
            sqlBuilder.Clear();
            return sql;
        }

        protected override void BuildQueryConditions(FbController2 fbController)
        {
            fbController.AddParameter("@BELE_L_BERECHNET", ZeigeGenehmigte);
            sqlBuilder.Append(@"AND BELE_A_TYP = 'LS' AND coalesce(BELE_N_NR_RE, 0) = 0 AND
BELE_L_STORNO = 'N' AND BELE_A_KUNDENNR  != '10100' AND BELE_L_BERECHNET = @BELE_L_BERECHNET");
        }
    }
}
