﻿using System;

namespace WK5.Core.Basis.Filter
{
    public class LieferantenkontaktFilter : PageFilter
    {
        public int Personal { get; set; }
        public DateTime Von { get; set; } = DateTime.Now.AddDays(-14);
        public DateTime Bis { get; set; } = DateTime.Now;

        public DateTime WiedervorlageVon { get; set; } = DateTime.Now;
        public DateTime WiedervorlageBis { get; set; } = DateTime.Now.AddDays(7);
        public bool ZeitraumBegrenzen { get; set; } = false;
        public bool WiedervorlageZeitraumBegrenzen { get; set; } = false;

        public LieferantenKontaktTyp Typ { get; set; } = LieferantenKontaktTyp.Alle;

        public int LieferantenId { get; set; }

        public bool ErledigteAnzeigen { get; set; }

        public int Bestellnummer { get; set; }

        public string Belegtyp { get; set; } = string.Empty;
        public int Belegnummer { get; set; }

        public override string ToCountQuery(FbController2 fbController)
        {
            sqlBuilder.Clear();
            sqlBuilder.Append("SELECT COUNT(*) FROM WK5_LIEFERANTENKONTAKTE WHERE 1=1");
            BuildQueryConditions(fbController);

            string sql = sqlBuilder.ToString();
            sqlBuilder.Clear();
            return sql;
        }

        public override string ToSqlQuery(FbController2 fbController)
        {
            sqlBuilder.Clear();
            sqlBuilder.Append($"SELECT FIRST {Limit} SKIP {(Seite - 1) * Limit} * FROM WK5_LIEFERANTENKONTAKTE WHERE 1=1");
            BuildQueryConditions(fbController);
            sqlBuilder.Append(" ORDER BY LFKO_N_ID DESC");

            string sql = sqlBuilder.ToString();
            sqlBuilder.Clear();
            return sql;

        }

        protected override void BuildQueryConditions(FbController2 fbController)
        {
            if (ZeitraumBegrenzen)
            {
                if (WiedervorlageVon != default)
                {
                    sqlBuilder.Append(" AND LFKO_D_DATE >= @VON");
                    fbController.AddParameter("@VON", Von);
                }

                if (Bis != default)
                {
                    sqlBuilder.Append(" AND LFKO_D_DATE <= @BIS");
                    fbController.AddParameter("@BIS", Bis);
                }
            }

            if (WiedervorlageZeitraumBegrenzen)
            {
                if (Von != default)
                {
                    sqlBuilder.Append(" AND (LFKO_D_WIEDERV_DATE+LFKO_T_WIEDERV_TIME) >= @WIEDERVVON");
                    fbController.AddParameter("@WIEDERVVON", WiedervorlageVon);
                }

                if (Bis != default)
                {
                    sqlBuilder.Append(" AND (LFKO_D_WIEDERV_DATE+LFKO_T_WIEDERV_TIME) <= @WIEDERVBIS");
                    fbController.AddParameter("@WIEDERVBIS", WiedervorlageBis);
                }
            }

            if(LieferantenId > 0)
            {
                sqlBuilder.Append(" AND LFKO_N_LFNR = @LFKO_N_LFNR");
                fbController.AddParameter("@LFKO_N_LFNR", LieferantenId);
            }

            if(Typ is not LieferantenKontaktTyp.Alle)
            {
                sqlBuilder.Append(" AND LFKO_N_ART = @LFKO_N_ART");
                fbController.AddParameter("@LFKO_N_ART", (int)Typ);
            }

            if (!ErledigteAnzeigen)
            {
                sqlBuilder.Append(" AND LFKO_L_WIEDERV_ERL = 'N'");
            }

            if(Bestellnummer > 0)
            {
                sqlBuilder.Append(" AND LFKO_N_BESTELLNR = @LFKO_N_BESTELLNR");
                fbController.AddParameter("@LFKO_N_BESTELLNR", Bestellnummer);
            }

            if (!string.IsNullOrWhiteSpace(Suchbegriff))
            {
                sqlBuilder.Append(" AND UPPER(LFKO_B_LANGNOTIZ) LIKE @SUCHBEGRIFF");
                fbController.AddParameter("@SUCHBEGRIFF", $"%{Suchbegriff}%");
            }

            if(!string.IsNullOrWhiteSpace(Belegtyp))
            {
                sqlBuilder.Append(" AND LFKO_A_BELEGTYP = @LFKO_A_BELEGTYP");
                fbController.AddParameter("@LFKO_A_BELEGTYP", Belegtyp);
            }

            if(Belegnummer > 0)
            {
                sqlBuilder.Append(" AND LFKO_N_BELEGNUMMER = @LFKO_N_BELEGNUMMER");
                fbController.AddParameter("@LFKO_N_BELEGNUMMER", Belegnummer);
            }

            if (Personal > 0)
            {
                sqlBuilder.Append(" AND LFKO_N_WIEDERV_USER = @PERSONAL");
                fbController.AddParameter("@PERSONAL", Personal);
            }
        }
    }
}
