﻿using System;
using WK5.Core.Models;
using WK5.Core.Services;

namespace WK5.Core.Basis.Filter
{
    public class LieferantenFilter : PageFilter
    {
        public bool ShowGesperrteLieferanten { get; set; }
        public bool Telefonnummernsuche { get; set; } = false;

        public bool NurEigenlieferantenAnzeigen { get; set; } = false;
        public bool NurNichtEigenlieferantenAnzeigen { get; set; } = false;

        public bool IsFilterActive
        {
            get
            {
                if (!String.IsNullOrWhiteSpace(Suchbegriff))
                {
                    return true;
                }
                if (ShowGesperrteLieferanten)
                {
                    return true;
                }

                return false;
            }
        }

        public override string ToSqlQuery(FbController2 fbController)
        {
            sqlBuilder.Clear();
            sqlBuilder.Append($"SELECT FIRST {Limit} SKIP {(Seite - 1) * Limit} * FROM LIEFERANTEN WHERE 1 = 1");
            BuildQueryConditions(fbController);
            sqlBuilder.Append(" ORDER BY LIEF_WK5_N_WICHTIGKEIT DESC");
            return sqlBuilder.ToString();
        }

        public override string ToCountQuery(FbController2 fbController)
        {
            sqlBuilder.Clear();
            sqlBuilder.Append($"SELECT COUNT(*) FROM LIEFERANTEN WHERE 1 = 1");
            BuildQueryConditions(fbController);
            return sqlBuilder.ToString();
        }

        protected override void BuildQueryConditions(FbController2 fbController)
        {
            if (!Telefonnummernsuche)
            {
                if (!String.IsNullOrWhiteSpace(Suchbegriff))
                {
                    if (Suchbegriff.Length > 255)
                    {
                        throw new ArgumentOutOfRangeException(nameof(Suchbegriff), "Darf nicht länger als 255 Zeichen sein.");
                    }

                    fbController.AddParameter("@SUCHBEGRIFF", $"%{Suchbegriff}%");
                    sqlBuilder.Append(@" AND 
(
    CAST(LIEF_N_NR AS VARCHAR(255)) LIKE @SUCHBEGRIFF 
OR CAST(UPPER(LIEF_A_NAME1) AS VARCHAR(255)) LIKE @SUCHBEGRIFF
OR CAST(UPPER(COALESCE(LIEF_A_USTIDNR, '')) AS VARCHAR(255)) LIKE @SUCHBEGRIFF 
OR CAST(UPPER(LIEF_A_NAME1) AS VARCHAR(255)) LIKE @SUCHBEGRIFF 
OR CAST(UPPER(LIEF_A_NAME2) AS VARCHAR(255)) LIKE @SUCHBEGRIFF 
OR CAST(UPPER(LIEF_A_PLZ) AS VARCHAR(255)) LIKE @SUCHBEGRIFF 
OR CAST(UPPER(LIEF_A_ORT) AS VARCHAR(255)) LIKE @SUCHBEGRIFF 
OR CAST(UPPER(LIEF_A_SUCHCODE) AS VARCHAR(255)) LIKE @SUCHBEGRIFF 
)");

                }
            }
            else
            {
                sqlBuilder.Append(" AND CAST(LIEF_N_NR AS TSTR100) IN (SELECT TELF_A_NR FROM TELEFONNUMMERN WHERE TELF_A_TYP = @TELF_A_TYP AND CAST(TELF_A_TELNR AS VARCHAR(255)) LIKE @TELF_A_TELNR)");
                fbController.AddParameter("@TELF_A_TYP", "LI");
                fbController.AddParameter("@TELF_A_TELNR", $"%{Telefonnummer.Sanitize(Suchbegriff)}%");
            }

            if (!ShowGesperrteLieferanten)
            {
                sqlBuilder.Append(" AND LIEF_L_SPERRE = 'N'");
            }

            if (NurEigenlieferantenAnzeigen)
            {
                sqlBuilder.Append(" AND LIEF_L_EIGENLIEFERANT = 'Y'");
            }

            if (NurNichtEigenlieferantenAnzeigen)
            {
                sqlBuilder.Append(" AND LIEF_L_EIGENLIEFERANT = 'N'");
            }
        }
    }
}
