﻿using System;

namespace WK5.Core.Basis.Filter
{
    public class LieferantenBestellungenFilter : PageFilter<LieferantenBestellungenSuchModus>
    {
        public Zeitraum Zeitraum { get; set; } = new Zeitraum(DateTime.Now.AddDays(-30), DateTime.Now);
        public bool ZeitraumFiltern { get; set; } = true;

        public int Lieferantennummer { get; set; }

        public override string ToSqlQuery(FbController2 fbController)
        {
            sqlBuilder.Append("SELECT BEST_N_NR FROM BESTELLUNGEN WHERE 1 = 1 ");

            BuildQueryConditions(fbController);

            sqlBuilder.Append(" ORDER BY BEST_D_DATE DESC, BEST_N_NR DESC");

            string sql = sqlBuilder.ToString();
            sqlBuilder.Clear();

            return sql;
        }

        public override string ToCountQuery(FbController2 fbController)
        {
            sqlBuilder.Append("SELECT COUNT(*) FROM BESTELLUNGEN WHERE 1 = 1");

            BuildQueryConditions(fbController);

            string sql = sqlBuilder.ToString();
            sqlBuilder.Clear();

            return sql;
        }


        protected override void BuildQueryConditions(FbController2 fbController)
        {
            sqlBuilder.Append(" AND BEST_N_LIEFNR = @BEST_N_LIEFNR");
            fbController.AddParameter("@BEST_N_LIEFNR", Lieferantennummer);

            if (ZeitraumFiltern)
            {
                sqlBuilder.Append(" AND BEST_D_DATE >= @START AND BEST_D_DATE <= @ENDE");
                fbController.AddParameter("@START", Zeitraum.Von);
                fbController.AddParameter("@ENDE", Zeitraum.Bis);
            }

            sqlBuilder.Append(Option switch
            {
                LieferantenBestellungenSuchModus.Offen => " AND BEST_L_ERLEDIGT = 'N'",
                LieferantenBestellungenSuchModus.NichtBestaetigt => " AND BEST_L_BESTAETIGT = 'N'",
                LieferantenBestellungenSuchModus.NichtVersendet => " AND BEST_L_VERSENDET = 'N'",
                _ => String.Empty
            });

        }
    }

}
