﻿using System;

namespace WK5.Core.Basis.Filter
{
    public class KundenkontaktFilter : PageFilter
    {
        public int Personal { get; set; }
        public DateTime Von { get; set; } = DateTime.Now.AddDays(-14);
        public DateTime Bis { get; set; } = DateTime.Now;

        public DateTime WiedervorlageVon { get; set; } = DateTime.Now;
        public DateTime WiedervorlageBis { get; set; } = DateTime.Now.AddDays(7);
        public bool ZeitraumBegrenzen { get; set; } = false;
        public bool WiedervorlageZeitraumBegrenzen { get; set; } = false;

        public bool ErledigteAnzeigen { get; set; }

        public string Kundennummer { get; set; } = string.Empty;

        public string Belegtyp { get; set; } = string.Empty;
        public int Belegnummer { get; set; }

        public override string ToCountQuery(FbController2 fbController)
        {
            sqlBuilder.Clear();
            sqlBuilder.Append("SELECT COUNT(*) FROM KUNDENKONTAKTE WHERE 1=1");
            BuildQueryConditions(fbController);

            string sql = sqlBuilder.ToString();
            sqlBuilder.Clear();
            return sql;
        }

        public override string ToSqlQuery(FbController2 fbController)
        {
            sqlBuilder.Clear();
            sqlBuilder.Append($"SELECT FIRST {Limit} SKIP {(Seite - 1) * Limit} * FROM KUNDENKONTAKTE WHERE 1=1");
            BuildQueryConditions(fbController);
            sqlBuilder.Append(" ORDER BY KUKO_N_ID DESC");

            string sql = sqlBuilder.ToString();
            sqlBuilder.Clear();
            return sql;

        }

        protected override void BuildQueryConditions(FbController2 fbController)
        {
            if (ZeitraumBegrenzen)
            {
                if (WiedervorlageVon != default)
                {
                    sqlBuilder.Append(" AND KUKO_D_DATE >= @VON");
                    fbController.AddParameter("@VON", Von);
                }

                if (Bis != default)
                {
                    sqlBuilder.Append(" AND KUKO_D_DATE <= @BIS");
                    fbController.AddParameter("@BIS", Bis);
                }

                if(!string.IsNullOrEmpty(Belegtyp))
                {
                    sqlBuilder.Append(" AND KUKO_A_BELEGTYP = @BELEGTYP");
                    fbController.AddParameter("@BELEGTYP", Belegtyp);
                }

                if(Belegnummer > 0)
                {
                    sqlBuilder.Append(" AND KUKO_N_BELEGNR = @BELEGNUMMER");
                    fbController.AddParameter("@BELEGNUMMER", Belegnummer);
                }
            }

            if (WiedervorlageZeitraumBegrenzen)
            {
                if (Von != default)
                {
                    sqlBuilder.Append(" AND (KUKO_D_WIEDERV_DATE+KUKO_T_WIEDERV_TIME) >= @WIEDERVVON");
                    fbController.AddParameter("@WIEDERVVON", WiedervorlageVon);
                }

                if (Bis != default)
                {
                    sqlBuilder.Append(" AND (KUKO_D_WIEDERV_DATE+KUKO_T_WIEDERV_TIME) <= @WIEDERVBIS");
                    fbController.AddParameter("@WIEDERVBIS", WiedervorlageBis);
                }
            }

            if(!string.IsNullOrWhiteSpace(Kundennummer))
            {
                sqlBuilder.Append(" AND KUKO_A_KUNDNR = @KUKO_A_KUNDNR");
                fbController.AddParameter("@KUKO_A_KUNDNR", Kundennummer);
            }

            if (!string.IsNullOrWhiteSpace(Suchbegriff))
            {
                sqlBuilder.Append(" AND UPPER(KUKO_WK5_B_LANGNOTIZ) LIKE @SUCHBEGRIFF");
                fbController.AddParameter("@SUCHBEGRIFF", $"%{Suchbegriff}%");
            }

            if (!ErledigteAnzeigen)
            {
                sqlBuilder.Append(" AND KUKO_L_WIEDERV_ERL = 'N'");
            }

            if (Personal > 0)
            {
                sqlBuilder.Append(" AND KUKO_N_WIEDERV_USER = @PERSONAL");
                fbController.AddParameter("@PERSONAL", Personal);
            }
        }
    }
}
