﻿using System;

namespace WK5.Core.Basis.Filter
{
    public class KundenBelegeFilter : PageFilter
    {
        private string _artikelnummer = String.Empty;

        public bool AngeboteAnzeigen { get; set; } = true;
        public bool AufträgeAnzeigen { get; set; } = true;
        public bool NurOffeneAufträgeAnzeigen { get; set; }
        public bool LieferscheineAnzeigen { get; set; } = true;
        public bool RechnungenAnzeigen { get; set; } = true;
        public bool NurOffeneRechnungenAnzeigen { get; set; }
        public bool GutschriftenAnzeigen { get; set; } = true;
        public bool RmaAnzeigen { get; set; } = true;
        public DateTime Von { get; set; } = DateTime.Now.AddDays(-14);
        public DateTime Bis { get; set; } = DateTime.Now;
        public bool ZeitraumEingrenzen { get; set; } = false;

        public string Artikelnummer { get => _artikelnummer; set => _artikelnummer = (value ?? String.Empty).Trim().ToUpper(); }

        
        public override string ToCountQuery(FbController2 fbController)
        {
            sqlBuilder.Clear();
            if(RmaAnzeigen)
            {
                sqlBuilder.Append("SELECT SUM(ANZAHL) FROM (");
            }
            sqlBuilder.Append("SELECT COUNT(*) AS ANZAHL FROM BELEGE WHERE 1 = 1");
            BuildQueryConditions(fbController);

            if(RmaAnzeigen)
            {
                sqlBuilder.Append(@"
UNION ALL
SELECT
COUNT(*) AS ANZAHL
FROM RMAS R
LEFT JOIN KUNDEN K ON K.KUND_A_NR = R.RMA_A_KUNDENNR
WHERE 1 = 1");
                BuildRmaQueryConditions(fbController);
                sqlBuilder.Append(')');
            }
            return sqlBuilder.ToString();
        }

        public override string ToSqlQuery(FbController2 fbController)
        {
            sqlBuilder.Clear();
            if(RmaAnzeigen)
            {
                sqlBuilder.Append($@"SELECT FIRST {Limit} SKIP {(Seite - 1) * Limit} * FROM (SELECT");
            }
            else
            {
                sqlBuilder.Append($@"SELECT FIRST {Limit} SKIP {(Seite - 1) * Limit}");
            }
            sqlBuilder.Append($@"
BELE_A_TYP, BELE_N_NR, BELE_D_DATE, BELE_N_NETTO, BELE_N_BRUTTO, BELE_A_NAME1
FROM BELEGE
WHERE 1 = 1");
            BuildQueryConditions(fbController);
            if(RmaAnzeigen)
            {
                sqlBuilder.Append(@"
UNION ALL
SELECT
'RM' AS BELE_A_TYP, RMA_N_NR AS BELE_N_NR, RMA_D_ANLAGEDATUM AS BELE_D_DATE, 0 AS BELE_N_NETTO, 0 AS BELE_N_BRUTTO, KUND_A_NAME1 AS BELE_A_NAME1
FROM RMAS R
LEFT JOIN KUNDEN K ON K.KUND_A_NR = R.RMA_A_KUNDENNR
WHERE 1 = 1");
                BuildRmaQueryConditions(fbController);
                sqlBuilder.Append(')');

            }
            sqlBuilder.Append(" ORDER BY BELE_D_DATE DESC, BELE_N_NR DESC");

            return sqlBuilder.ToString();
        }
        private void BuildRmaQueryConditions(FbController2 fbController)
        {
            sqlBuilder.Append($@" AND RMA_A_KUNDENNR = @SUCHBEGRIFF");


            if (!String.IsNullOrWhiteSpace(Artikelnummer))
            {
                sqlBuilder.Append(" AND RMA_A_ARTIKELNR LIKE @ARTIKELNUMMER");
            }

            if (ZeitraumEingrenzen)
            {
                if (Von != default(DateTime))
                {
                    sqlBuilder.Append(" AND RMA_D_ANLAGEDATUM >= @VON");
                }

                if (Bis != default(DateTime))
                {
                    sqlBuilder.Append(" AND RMA_D_ANLAGEDATUM <= @BIS");
                }
            }
        }
        protected override void BuildQueryConditions(FbController2 fbController)
        {
            if (AngeboteAnzeigen || AufträgeAnzeigen || LieferscheineAnzeigen || RechnungenAnzeigen || GutschriftenAnzeigen)
            {
                sqlBuilder.Append(" AND (");
                if (AngeboteAnzeigen)
                {
                    sqlBuilder.Append(" BELE_A_TYP = 'AN'");
                }
                else
                {
                    sqlBuilder.Append(" 1=0");
                }

                if (AufträgeAnzeigen)
                {
                    sqlBuilder.Append(" OR ( ");
                    sqlBuilder.Append(" BELE_A_TYP = 'AU' ");
                    if (NurOffeneAufträgeAnzeigen)
                    {
                        sqlBuilder.Append(" AND BELE_L_ERLEDIGT = 'N' ");
                    }
                    sqlBuilder.Append(" ) ");
                }
                else
                {
                    sqlBuilder.Append(" OR 1=0");
                }

                if (LieferscheineAnzeigen)
                {
                    sqlBuilder.Append(" OR BELE_A_TYP = 'LS'");
                }
                else
                {
                    sqlBuilder.Append(" OR 1=0");
                }

                if (RechnungenAnzeigen)
                {                    
                    sqlBuilder.Append("OR ( ");
                    sqlBuilder.Append(" BELE_A_TYP = 'RE' ");
                    if (NurOffeneRechnungenAnzeigen)
                    {
                        sqlBuilder.Append(" AND BELE_L_BEZAHLT = 'N' ");
                    }
                    sqlBuilder.Append(" ) ");
                }
                else
                {
                    sqlBuilder.Append(" OR 1=0");
                }

                if (GutschriftenAnzeigen)
                {
                    sqlBuilder.Append(" OR BELE_A_TYP = 'GU'");
                }
                else
                {
                    sqlBuilder.Append(" OR 1=0");
                }

                sqlBuilder.Append(")");
            }
            else
            {
                sqlBuilder.Append(" AND BELE_A_TYP = 'RM'");
            }


            if (!String.IsNullOrWhiteSpace(Suchbegriff))
            {
                sqlBuilder.Append(" AND BELE_A_KUNDENNR = @SUCHBEGRIFF");
                fbController.AddParameter("@SUCHBEGRIFF", Suchbegriff);
            }

            if (!String.IsNullOrWhiteSpace(Artikelnummer))
            {
                sqlBuilder.Append(" AND EXISTS(SELECT BPOS_N_POSID FROM BELEGPOS WHERE BPOS_A_TYP = BELE_A_TYP AND BPOS_N_NR = BELE_N_NR AND BPOS_A_ARTIKELNR LIKE @ARTIKELNUMMER)");
                fbController.AddParameter("@ARTIKELNUMMER", $"{Artikelnummer}%");
            }

            if (ZeitraumEingrenzen)
            {
                if (Von != default(DateTime))
                {
                    sqlBuilder.Append(" AND BELE_D_DATE >= @VON");
                    fbController.AddParameter("@VON", Von.ToShortDateString());
                }

                if (Bis != default(DateTime))
                {
                    sqlBuilder.Append(" AND BELE_D_DATE <= @BIS");
                    fbController.AddParameter("@BIS", Bis.ToShortDateString());
                }
            }  
            
            
        }
    }
}
