﻿using System;

namespace WK5.Core.Basis.Filter
{
    public class KundenArtikelHistorieFilter : PageFilter
    {
        private string _artikelnummer = String.Empty;

        public BelegTyp Belegtyp { get; set; }
        public string Artikelnummer { get => _artikelnummer; set => _artikelnummer = (value ?? String.Empty).Trim().ToUpper(); }
        public string Kundennummer { get; set; } = String.Empty;
        public override string ToCountQuery(FbController2 fbController)
        {
            sqlBuilder.Clear();
            sqlBuilder.Append(@"SELECT COUNT(*) FROM BELEGE ");
            BuildQueryConditions(fbController);
            return sqlBuilder.ToString();
        }

        public override string ToSqlQuery(FbController2 fbController)
        {
            sqlBuilder.Clear();
            sqlBuilder.Append(@$"SELECT FIRST {Limit} SKIP {(Seite - 1) * Limit} BPOS_A_TYP, BPOS_A_BEZ1, BPOS_A_BEZ2, BPOS_N_NR, BPOS_N_MENGE, BPOS_N_PREIS, BELE_D_DATE, BPOS_N_MENGEGELIEF, BPOS_A_ARTIKELNR  FROM BELEGE ");
            BuildQueryConditions(fbController);
            sqlBuilder.Append(" ORDER BY BELE_D_DATE DESC");
            return sqlBuilder.ToString();
        }


        //T1 und Text rausfiltern
        protected override void BuildQueryConditions(FbController2 fbController)
        {
            sqlBuilder.Append(" LEFT JOIN BELEGPOS ON (BELE_N_NR = BPOS_N_NR AND BELE_A_TYP = BPOS_A_TYP) WHERE 1=1");

            sqlBuilder.Append(" AND BELE_A_KUNDENNR = @KUNDENNR");
            fbController.AddParameter("@KUNDENNR", Kundennummer);

            sqlBuilder.Append(" AND BPOS_A_TYP = @TYP");
            fbController.AddParameter("@TYP", EnumHelper.GetBelegTypString(Belegtyp));

            sqlBuilder.Append(" AND (BPOS_A_ARTIKELNR != 'T1' AND BPOS_A_ARTIKELNR != 'TEXT')");

            if (!String.IsNullOrWhiteSpace(Artikelnummer))
            {
                sqlBuilder.Append(" AND BPOS_A_ARTIKELNR LIKE @ARTIKELNUMMER");
                fbController.AddParameter("@ARTIKELNUMMER", $"{Artikelnummer}%");
            }

        }
    }
}
