﻿using System;

namespace WK5.Core.Basis.Filter
{
    public class HerstellerFilter : Filter
    {

        public override string ToSqlQuery(FbController2 fbController)
        {
            sqlBuilder.Clear();
            sqlBuilder.Append("SELECT FIRST 30 * FROM HERSTELLER WHERE 1 = 1");

            BuildQueryConditions(fbController);

            return sqlBuilder.ToString();
        }

        protected override void BuildQueryConditions(FbController2 fbController)
        {
            if (!String.IsNullOrWhiteSpace(Suchbegriff))
            {
                if (Suchbegriff.Length > 255)
                {
                    throw new ArgumentOutOfRangeException(nameof(Suchbegriff));
                }

                sqlBuilder.Append($@" AND 
(
CAST(UPPER(HEST_A_NR) AS VARCHAR(255)) LIKE @SUCHBEGRIFF 
OR CAST(UPPER(HEST_A_NAME1) AS VARCHAR(255)) LIKE @SUCHBEGRIFF 
OR CAST(UPPER(HEST_A_NAME2) AS VARCHAR(255)) LIKE @SUCHBEGRIFF
)");
                fbController.AddParameter("@SUCHBEGRIFF", $"%{Suchbegriff}%");
            }
        }
    }
}
