﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WK5.Core.Basis.Filter
{
    public class GesamtUmsatzFilter : Filter
    {
        public DateTime Von{ get; set; }
        public DateTime Bis { get; set; }
        public override string ToSqlQuery(FbController2 fbController)
        {
            
            sqlBuilder.Append(@"select sum(netto) from(select case when BELE_A_TYP = 'RE'THEN SUM(BELE_N_NETTO) else -sum(BELE_N_NETTO) end as netto from BELEGE 
                                where bele_a_typ in ('RE', 'GU')  ");
            BuildQueryConditions(fbController);

            sqlBuilder.Append(" group by bele_a_typ)");

            string tmp = sqlBuilder.ToString();
            sqlBuilder.Clear();
            return tmp;
        }

        protected override void BuildQueryConditions(FbController2 fbController)
        {
            sqlBuilder.Append(" and BELE_D_DATE >= @Von and BELE_D_DATE <= @Bis");
            fbController.AddParameter("@Von", Von);
            fbController.AddParameter("@Bis", Bis);
        }
        public GesamtUmsatzFilter()
        {
            DateTime aktuell = DateTime.Now;
            DateTime letzerMonat = aktuell.AddMonths(-1);

            Von = new DateTime(letzerMonat.Year, letzerMonat.Month, 1);
            Bis = new DateTime(letzerMonat.Year, letzerMonat.Month, DateTime.DaysInMonth(letzerMonat.Year, letzerMonat.Month));
        }
    }
    
}
