﻿using System;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace WK5.Core.Basis.Filter
{
    /// <summary>
    /// Stellt einen Filter zum Suchen dar. Diese Klasse ist Abstrakt.
    /// </summary>
    public abstract class Filter
    {
        private string _suchbegriff = String.Empty;
        /// <summary>
        /// Für die Generierung der SQL-Statements. 
        /// <para>
        /// Der sqlBuilder sollte am Ende immer gecleared werden.
        /// </para>
        /// </summary>
        protected StringBuilder sqlBuilder = new StringBuilder();

        /// <summary>
        /// Ruft einen Suchbegriff ab, oder legt diesen fest.
        /// <para>
        /// Der Wert wird beim schreiben immer auf als UPPERCASE gesetzt. Wenn null übergeben wird, dann ist der Wert <see cref="String.Empty" />
        /// </para>
        /// </summary>
        [MaxLength(255)]
        public string Suchbegriff
        {
            get => _suchbegriff;
            set
            {
                if (value is null)
                {
                    _suchbegriff = String.Empty;
                    return;
                }
                _suchbegriff = value.ToUpper().Trim();

            }
        }
        /// <summary>
        /// Generiert die standardisierte SQL, um eine Suchanfrage mit dem Filter durchzuführen.
        /// </summary>
        /// <param name="fbController"></param>
        /// <returns></returns>
        public abstract string ToSqlQuery(FbController2 fbController);
        /// <summary>
        /// Generiert die Bedingungen der SQL-Where Clause und legt ggf. Parameter für diese fest.
        /// </summary>
        /// <param name="fbController"></param>
        protected abstract void BuildQueryConditions(FbController2 fbController);
    }



}
