﻿using System;

namespace WK5.Core.Basis.Filter
{
    /// <summary>
    /// Stellt einen Filter zum suchen nach Chargen dar.
    /// </summary>
    public class ChargenFilter : Filter
    {
        /// <summary>
        /// Gibt an, dass nur Chargen für eine bestimmte Artikelnummer gesucht werden sollen.
        /// </summary>
        public string Artikelnummer { get; set; } = String.Empty;
        /// <summary>
        /// Gibt an, dass nur Chargen gesucht werden, die noch über offenen Bestand verfügen.
        /// </summary>
        public bool NurOffene { get; set; }
        /// <summary>
        /// Gibt an, ob die neuesten Chargen als erstes angezeigt werden sollen, oder die ältesten
        /// </summary>
        public bool NeuesteZuerst { get; set; }
        /// <summary>
        /// Die maximale Menge die die Charge haben darf. 0 = ignorieren
        /// </summary>
        public int MaxMenge { get; set; }
        public override string ToSqlQuery(FbController2 fbController)
        {
            sqlBuilder.Append(@"SELECT C.*, LIEF_A_NAME1, ZUGA_D_DATUM FROM CHARGEN C 
LEFT JOIN ZUGAENGE Z ON Z.ZUGA_N_NR = C.CHAR_N_STAPELNR
LEFT JOIN LIEFERANTEN LF ON LF.LIEF_N_NR = Z.ZUGA_N_LIEF
WHERE 1 = 1");

            BuildQueryConditions(fbController);

            if(NeuesteZuerst)
            {
                sqlBuilder.Append(" ORDER BY CHAR_N_NR DESC");
            }

            string tmp = sqlBuilder.ToString();
            sqlBuilder.Clear();
            return tmp;
        }

        protected override void BuildQueryConditions(FbController2 fbController)
        {
            if (!String.IsNullOrWhiteSpace(Artikelnummer))
            {
                sqlBuilder.Append(" AND CHAR_A_ARTINR = @CHAR_A_ARTINR");
                fbController.AddParameter("@CHAR_A_ARTINR", Artikelnummer);
            }

            if (NurOffene)
            {
                sqlBuilder.Append(" AND CHAR_N_MENGEOFFEN > 0");
            }

            if (!String.IsNullOrWhiteSpace(Suchbegriff))
            {
                if (Suchbegriff.Length > 255)
                {
                    throw new ArgumentOutOfRangeException(nameof(Suchbegriff), "Der Suchbegriff darf nicht länger als 255 Zeichen sein");
                }

                sqlBuilder.Append(" AND CAST(CHAR_N_NR AS VARCHAR(255)) LIKE @SUCHBEGRIFF");
                fbController.AddParameter("@SUCHBEGRIFF", $"%{Suchbegriff}%");
            }

            if(MaxMenge > 0)
            {
                sqlBuilder.Append(" AND CHAR_N_MENGE < @MAXMENGE");
                fbController.AddParameter("@MAXMENGE", MaxMenge);
            }
        }
    }
}
