﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace WK5.Core.Basis.Filter
{
    public class BestellungFilter : PageFilter<BestellungFilterOption>
    {
        public int LieferantId { get; set; }
        public bool ZeigeKeineDirektlieferungen { get; set; }
        public List<int> NichtBestellungIds { get; set; } = new List<int>();
        public bool ZeitraumEingrenzen { get; set; }
        public DateTime Von { get; set; }
        public DateTime Bis { get; set; }
        public bool IsFilterActive
        {
            get
            {
                if (!String.IsNullOrWhiteSpace(Suchbegriff))
                {
                    return true;
                }

                if (Option is not BestellungFilterOption.NurOffeneBestellungen)
                {
                    return true;
                }


                return false;
            }
        }
        public override string ToCountQuery(FbController2 fbController)
        {
            sqlBuilder.Append(@$"SELECT COUNT(*) FROM BESTELLUNGEN B 
LEFT JOIN BELEGE BE ON (BE.BELE_A_TYP = 'AU' AND BE.BELE_N_NR = B.BEST_N_AB_NR) 
LEFT JOIN LIEFERANTEN LF ON B.BEST_N_LIEFNR = LF.LIEF_N_NR
WHERE 1 = 1");
            BuildQueryConditions(fbController);
            string sql = sqlBuilder.ToString();
            sqlBuilder.Clear();
            return sql;
        }

        public override string ToSqlQuery(FbController2 fbController)
        {
            if (!Enum.IsDefined(typeof(BestellungFilterOption), Option))
            {
                throw new ArgumentOutOfRangeException(nameof(Option));
            }

            sqlBuilder.Append(@$"SELECT FIRST {Limit} SKIP {(Seite - 1) * Limit}
LIEF_A_NAME1, LIEF_A_NAME2, KUND_A_NAME1, KUND_A_NAME2, B.*, WK5_BELE_L_DIREKTLIEFERUNG
FROM BESTELLUNGEN B
LEFT JOIN LIEFERANTEN LF ON B.BEST_N_LIEFNR = LF.LIEF_N_NR
LEFT JOIN KUNDEN K ON B.BEST_A_LIEFERKUNDE = K.KUND_A_NR
LEFT JOIN BELEGE BE ON(BE.BELE_A_TYP = 'AU' AND BE.BELE_N_NR = B.BEST_N_AB_NR)
WHERE 1 = 1");
            BuildQueryConditions(fbController);
            sqlBuilder.Append(" ORDER BY BEST_N_NR DESC");

            string sql = sqlBuilder.ToString();
            sqlBuilder.Clear();
            return sql;
        }

        protected override void BuildQueryConditions(FbController2 fbController)
        {
            sqlBuilder.Append(Option switch
            {
                BestellungFilterOption.NurOffeneBestellungen => " AND BEST_L_ERLEDIGT = 'N'",
                BestellungFilterOption.OffenUndNichtBestätigt => " AND BEST_L_ERLEDIGT = 'N' AND BEST_L_BESTAETIGT = 'N'",
                BestellungFilterOption.OffenUndNichtVersendet => " AND BEST_L_ERLEDIGT = 'N' AND BEST_L_VERSENDET = 'N'",
                _ => String.Empty,
            });
            if (!String.IsNullOrWhiteSpace(Suchbegriff))
            {
                sqlBuilder.Append(@" AND (CAST(BEST_N_NR as VARCHAR(255)) LIKE @SUCHBEGRIFF 
OR CAST(BEST_N_LIEFNR as VARCHAR(255)) LIKE @SUCHBEGRIFF
OR CAST(LF.LIEF_A_SUCHCODE as VARCHAR(255)) LIKE @SUCHBEGRIFF
OR CAST(BEST_A_BESTAET_NR_LIEF AS VARCHAR(255)) LIKE @SUCHBEGRIFF
OR EXISTS(SELECT 1 FROM LIEFERANTEN WHERE LIEF_N_NR = BEST_N_LIEFNR AND UPPER(CAST(UPPER(LIEF_A_NAME1) as VARCHAR(255))) LIKE @SUCHBEGRIFF))");

                fbController.AddParameter("@SUCHBEGRIFF", $"%{Suchbegriff}%");
            }

            if (LieferantId > 0)
            {
                sqlBuilder.Append(" AND BEST_N_LIEFNR = @BEST_N_LIEFNR");
                fbController.AddParameter("@BEST_N_LIEFNR", LieferantId);
            }

            if(ZeitraumEingrenzen)
            {
                sqlBuilder.Append(" AND BEST_D_DATE >= @VON");
                sqlBuilder.Append(" AND BEST_D_DATE <= @BIS");
                fbController.AddParameter("@VON", Von.ToShortDateString());
                fbController.AddParameter("@BIS", Bis.ToShortDateString());
            }

            if (ZeigeKeineDirektlieferungen)
            {
                sqlBuilder.Append(" AND (WK5_BELE_L_DIREKTLIEFERUNG IS NULL OR WK5_BELE_L_DIREKTLIEFERUNG = 'N')");
            }

            if (NichtBestellungIds.Any())
            {
                sqlBuilder.Append($" AND BEST_N_NR NOT IN({String.Join(',', NichtBestellungIds)})");
            }
        }
    }

    public enum BestellungFilterOption
    {
        NurOffeneBestellungen,
        OffenUndNichtBestätigt,
        OffenUndNichtVersendet,
        AlleBestellungen
    }
}
