﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WK5.Core.Basis.Filter
{
    public class AuftragsFreigabeFilter : Filter
    {
        public bool TechnikAufträge { get; set; } = false;        
        public bool Bezahlt { get; set; } = false;
        public bool NichtBezahlt { get; set; } = false;
        public bool LieferterminWeichtVonBestellungAb { get; set; } = false;

        public bool IsFilterActive
        {
            get
            {
                if (!String.IsNullOrWhiteSpace(Suchbegriff))
                {
                    return true;
                }

                if (TechnikAufträge)
                {
                    return true;
                }                

                if (Bezahlt)
                {
                    return true;
                }

                if (NichtBezahlt)
                {
                    return true;
                }

                if (LieferterminWeichtVonBestellungAb)
                {
                    return true;
                }

                return false;
            }
        }

        public override string ToSqlQuery(FbController2 fbController)
        {
            sqlBuilder.Clear();
            sqlBuilder.Append(@"SELECT DISTINCT 
B.*, 
FREI_D_PACKENAB, 
KUND_L_SPERRE, 
KUND_L_SPERRE_OP,
CASE WHEN KUND_L_SPERRE_OP = 'Y' THEN
(
    SELECT SUM(OP) AS OFFENEPOSTEN FROM
    (
        SELECT
            BELE_A_TYP, 
            CASE WHEN BELE_A_TYP = 'GU' THEN
                 -COALESCE(SUM(BELE_N_BRUTTO), 0) - COALESCE(SUM(BEZAHLTBETRAG), 0)
            ELSE
                 COALESCE(SUM(BELE_N_BRUTTO), 0) - COALESCE(SUM(BEZAHLTBETRAG), 0)
            END AS OP
        FROM
            KUNDENBELEGE
        WHERE
            ((BELE_A_TYP ='RE' AND BELE_L_BEZAHLT = 'N') OR (BELE_A_TYP ='GU' AND BELE_L_VERRECHNET = 'N'))
            AND BELE_A_KUNDENNR = K.KUND_A_NR
        GROUP BY BELE_A_TYP
    )
) ELSE
    0
END AS OFFENEPOSTEN
FROM BELEGE B
LEFT JOIN KUNDEN K ON K.KUND_A_NR = B.BELE_A_KUNDENNR
LEFT JOIN WK5_AUFTRAGSFREIGABE AF ON AF.FREI_N_BELENR = B.BELE_N_NR
LEFT JOIN BELEGPOS BPOS ON BELE_N_NR = BPOS_N_NR AND BELE_A_TYP = BPOS_A_TYP");

            if (LieferterminWeichtVonBestellungAb)
            {
                sqlBuilder.Append(" LEFT JOIN BESTELLUNGEN ON BELE_N_NR = BEST_N_AB_NR");
            }

sqlBuilder.Append(@" WHERE EXISTS ( SELECT BPOS_N_NR  FROM BELEGPOS WHERE  BPOS_N_MENGE > 0 AND  BPOS_N_MENGE > BPOS_N_MENGEGELIEF  AND BPOS_N_NR = BELE_N_NR AND BPOS_A_TYP = 'AU') 
AND BELE_L_ERLEDIGT = 'N' 
AND BELE_A_TYP = 'AU' 
AND BELE_L_STORNO = 'N'
AND (BELE_N_NR NOT IN (SELECT FREI_N_BELENR FROM WK5_AUFTRAGSFREIGABE) OR BELE_N_NR = 42718)");
            BuildQueryConditions(fbController);
            sqlBuilder.Append(" ORDER BY BELE_N_NR DESC");
            return sqlBuilder.ToString();
        }

        protected override void BuildQueryConditions(FbController2 fbController)
        {
            if (!String.IsNullOrWhiteSpace(Suchbegriff))
            {
                sqlBuilder.Append(@" AND ( 
CAST(BELE_N_NR AS VARCHAR(255)) LIKE @SUCHBEGRIFF 
OR CAST(BELE_A_KUNDENNR AS VARCHAR(255)) LIKE @SUCHBEGRIFF 
OR CAST(BELE_A_NAME1 || BELE_A_NAME2 || BELE_A_NAME3 AS VARCHAR(255)) LIKE @SUCHBEGRIFF
)");
                fbController.AddParameter("@SUCHBEGRIFF", Suchbegriff);
            }

            if (TechnikAufträge)
            {
                sqlBuilder.Append(@" AND (SELECT COUNT(*) FROM BELEGPOS WHERE BPOS_N_NR = BELE_N_NR AND BPOS_A_TYP = BELE_A_TYP 
AND (UPPER(BPOS_A_ARTIKELNR) LIKE 'SERV%'
OR UPPER(BPOS_A_ARTIKELNR) LIKE 'SO-%')) > 0");
            }

            if (Bezahlt)
            {
                sqlBuilder.Append(" AND IIF(BELE_N_ZAHLUNG IN (SELECT ZABD_N_NR FROM ZAHLUNGSBEDINGUNG WHERE ZABD_L_FACTORING = 'Y'),TRUE,BELE_L_BEZAHLT = 'Y') = TRUE ");
            }

            if (NichtBezahlt)
            {
                sqlBuilder.Append(" AND IIF(BELE_N_ZAHLUNG IN (SELECT ZABD_N_NR FROM ZAHLUNGSBEDINGUNG WHERE ZABD_L_FACTORING = 'Y'),TRUE,BELE_L_BEZAHLT = 'Y') = FALSE ");
            }

            if (LieferterminWeichtVonBestellungAb)
            {
                sqlBuilder.Append("  AND BEST_N_AB_NR > 0 AND IIF(COALESCE(BELE_D_LIEFERDATE,'') = '',TRUE,BELE_D_LIEFERDATE = COALESCE(BEST_D_LIEFTERMIN,BELE_D_LIEFERDATE)) = FALSE");
            }
        }
    }
}
