﻿using System;

namespace WK5.Core.Basis.Filter
{
    public class ArtikelBestellungenFilter : PageFilter
    {
        public DateTime Von { get; set; } = DateTime.Now.AddDays(-14);
        public DateTime Bis { get; set; } = DateTime.Now;
        public bool ZeitraumEingrenzen { get; set; } = false;
        public bool NurNichtErledigte { get; set; }

        public override string ToCountQuery(FbController2 fbController)
        {
            sqlBuilder.Clear();
            sqlBuilder.Append(@$"SELECT COUNT(*) FROM BESTELLUNGEN_POS
LEFT JOIN BESTELLUNGEN ON BEPO_N_BESTNR = BEST_N_NR
LEFT JOIN LIEFERANTEN ON BEST_N_LIEFNR = LIEF_N_NR
WHERE 1=1");
            BuildQueryConditions(fbController);

            string tmp = sqlBuilder.ToString();
            sqlBuilder.Clear();
            return tmp;
        }

        public override string ToSqlQuery(FbController2 fbController)
        {
            sqlBuilder.Clear();
            sqlBuilder.Append(@$"SELECT FIRST {Limit} SKIP {(Seite - 1) * Limit} BEPO_N_BESTNR, BEPO_N_POS, BEPO_N_MENGE, BEPO_N_LIEFERMENGE,
BEPO_D_LIEFERDAT, BEPO_N_PREIS, BEPO_L_ERLEDIGT, BEST_N_LIEFNR, LIEF_A_NAME1, BEST_D_DATE
FROM BESTELLUNGEN_POS
LEFT JOIN BESTELLUNGEN ON BEPO_N_BESTNR = BEST_N_NR
LEFT JOIN LIEFERANTEN ON BEST_N_LIEFNR = LIEF_N_NR
WHERE 1=1");
            BuildQueryConditions(fbController);
            sqlBuilder.Append(" ORDER BY BEPO_N_BESTNR DESC");

            string tmp = sqlBuilder.ToString();
            sqlBuilder.Clear();
            return tmp;
        }

        protected override void BuildQueryConditions(FbController2 fbController)
        {
            if (!String.IsNullOrWhiteSpace(Suchbegriff))
            {
                sqlBuilder.Append(" AND BEPO_A_ARTIKELNR = @SUCHBEGRIFF");
                fbController.AddParameter("@SUCHBEGRIFF", Suchbegriff);
            }

            if (ZeitraumEingrenzen)
            {

                if (Von != default)
                {
                    sqlBuilder.Append(" AND BEST_D_DATE >= @VON");
                    fbController.AddParameter("@VON", Von);
                }

                if (Bis != default)
                {
                    sqlBuilder.Append(" AND BEST_D_DATE <= @BIS");
                    fbController.AddParameter("@BIS", Bis);
                }
            }

            if (NurNichtErledigte)
            {
                sqlBuilder.Append(" AND BEPO_L_ERLEDIGT = 'N'");
            }
        }
    }
}
