﻿using System;

namespace WK5.Core.Basis.Filter
{
    public class ArtikelBelegübersichtFilter : PageFilter
    {
        public bool AngeboteAnzeigen { get; set; } = true;
        public bool AufträgeAnzeigen { get; set; } = true;
        public bool NurOffeneAufträgeAnzeigen { get; set; }
        public bool LieferscheineAnzeigen { get; set; } = true;
        public bool RechnungenAnzeigen { get; set; } = true;
        public bool GutschriftenAnzeigen { get; set; } = true;
        public DateTime Von { get; set; } = DateTime.Now.AddDays(-14);
        public DateTime Bis { get; set; } = DateTime.Now;
        public bool ZeitraumEingrenzen { get; set; } = false;
        public override string ToCountQuery(FbController2 fbController)
        {
            sqlBuilder.Clear();
            sqlBuilder.Append("SELECT COUNT(*) FROM BELEGPOS LEFT JOIN BELEGE ON BPOS_A_TYP = BELE_A_TYP AND BPOS_N_NR = BELE_N_NR  WHERE 1 = 1");
            BuildQueryConditions(fbController);

            return sqlBuilder.ToString();
        }

        public override string ToSqlQuery(FbController2 fbController)
        {
            sqlBuilder.Clear();
            sqlBuilder.Append($@"SELECT FIRST {Limit} SKIP {(Seite - 1) * Limit} BPOS_A_TYP, BPOS_N_NR, BELE_D_DATE, BELE_A_KUNDENNR,BELE_A_NAME1, BELE_A_LAND, BELE_A_ORT, SUM(BPOS_N_MENGE) as MENGE, SUM(BPOS_N_MENGEGELIEF) as GELIEFERT
FROM BELEGPOS 
LEFT JOIN BELEGE ON BPOS_A_TYP = BELE_A_TYP AND BPOS_N_NR = BELE_N_NR 
WHERE 1 = 1");
            BuildQueryConditions(fbController);
            sqlBuilder.Append(" GROUP BY BPOS_A_TYP, BPOS_N_NR, BELE_D_DATE, BELE_A_KUNDENNR,BELE_A_NAME1, BELE_A_LAND, BELE_A_ORT ORDER BY BELE_D_DATE DESC, BPOS_N_NR DESC");

            return sqlBuilder.ToString();
        }

        protected override void BuildQueryConditions(FbController2 fbController)
        {
            if (AngeboteAnzeigen || AufträgeAnzeigen || LieferscheineAnzeigen || RechnungenAnzeigen || GutschriftenAnzeigen)
            {
                sqlBuilder.Append(" AND (");
                if (AngeboteAnzeigen)
                {
                    sqlBuilder.Append(" BPOS_A_TYP = 'AN'");
                }
                else
                {
                    sqlBuilder.Append(" 1=0");
                }

                if (AufträgeAnzeigen)
                {
                    sqlBuilder.Append(" OR BPOS_A_TYP = 'AU'");
                }
                else
                {
                    sqlBuilder.Append(" OR 1=0");
                }

                if (LieferscheineAnzeigen)
                {
                    sqlBuilder.Append(" OR BPOS_A_TYP = 'LS'");
                }
                else
                {
                    sqlBuilder.Append(" OR 1=0");
                }

                if (RechnungenAnzeigen)
                {
                    sqlBuilder.Append(" OR BPOS_A_TYP = 'RE'");
                }
                else
                {
                    sqlBuilder.Append(" OR 1=0");
                }

                if (GutschriftenAnzeigen)
                {
                    sqlBuilder.Append(" OR BPOS_A_TYP = 'GU'");
                }
                else
                {
                    sqlBuilder.Append(" OR 1=0");
                }

                sqlBuilder.Append(")");
            }


            if (!String.IsNullOrWhiteSpace(Suchbegriff))
            {
                sqlBuilder.Append(" AND BPOS_A_ARTIKELNR = @SUCHBEGRIFF");
                fbController.AddParameter("@SUCHBEGRIFF", Suchbegriff);
            }

            if (ZeitraumEingrenzen)
            {
                sqlBuilder.Append(" AND BELE_D_DATE BETWEEN @VON AND @BIS");
                fbController.AddParameter("@VON", Von.ToShortDateString());
                fbController.AddParameter("@BIS", Bis.ToShortDateString());
            }

            if (NurOffeneAufträgeAnzeigen && AufträgeAnzeigen)
            {
                sqlBuilder.Append(" AND BELE_L_ERLEDIGT = 'N'");
            }
        }
    }
}
