﻿using Microsoft.AspNetCore.Components;
using Microsoft.JSInterop;
using System.Threading.Tasks;

namespace WK5.Core.Basis.Erweiterungen
{
    public static class NavigationManagerErweiterung
    {
        /// <summary>
        /// Erweiterungsmethode, um zu einem URL-Fragment zu springen.
        /// </summary>
        /// <param name="navigationManager"></param>
        /// <param name="jSRuntime"></param>
        /// <returns></returns>
        public static ValueTask NavigateToFragmentAsync(this NavigationManager navigationManager, IJSRuntime jSRuntime)
        {
            var uri = navigationManager.ToAbsoluteUri(navigationManager.Uri);

            if (uri.Fragment.Length == 0)
            {
                return default;
            }

            return jSRuntime.InvokeVoidAsync("blazorHelpers.scrollToFragment", uri.Fragment.Substring(1));
        }
    }
}
