﻿using Microsoft.JSInterop;
using System.Threading.Tasks;

namespace WK5.Core.Basis.Erweiterungen
{
    public static class IJSRuntimeExtensions
    {
        /// <summary>
        /// Zeigt ein SweetAlert2 an.
        /// </summary>
        /// <param name="js"></param>
        /// <param name="title"></param>
        /// <param name="message"></param>
        /// <param name="type"></param>
        /// <param name="timer"></param>
        /// <returns></returns>
        public static ValueTask ShowSweetAlert2(this IJSRuntime js, string title, string message, SweetAlertMessageType type, int timer = 0)
        {
            return js.InvokeVoidAsync("blazorHelpers.showSweetAlert", type.ToString(), title, message, timer);
        }
        /// <summary>
        /// Zeigt eine Toastbenachrichtigung an.
        /// </summary>
        /// <param name="js"></param>
        /// <param name="type"></param>
        /// <param name="message"></param>
        /// <param name="timeout"></param>
        /// <returns></returns>
        public static ValueTask ShowToast(this IJSRuntime js, ToastType type, string message, int timeout = 5000)
        {
            return js.InvokeVoidAsync("blazorHelpers.showToast", type.ToString(), message, timeout);
        }
        /// <summary>
        /// Öffnet eine URL im neuen Tab.
        /// </summary>
        /// <param name="js"></param>
        /// <param name="url"></param>
        /// <returns></returns>
        public static ValueTask OpenNewTab(this IJSRuntime js, string url)
        {
            return js.InvokeVoidAsync("blazorHelpers.open", url);
        }
        /// <summary>
        /// Fokussiert ein Element nach ID.
        /// </summary>
        /// <param name="js"></param>
        /// <param name="id"></param>
        /// <returns></returns>
        public static ValueTask FocusByIdAsync(this IJSRuntime js, string id)
        {
            return js.InvokeVoidAsync("blazorHelpers.setFocusById", id);
        }
    }

    public enum ToastType
    {
        warning, error, success
    }
    public enum SweetAlertMessageType
    {
        question, warning, error, success, info
    }
}
