﻿using System;

namespace WK5.Core.Basis
{
    /// <summary>
    /// Stellt ein Alert in der WK5 dar.
    /// </summary>
    public class AlertBox
    {
        public AlertBox()
        {

        }

        public AlertBox(string message, AlertType alertType)
        {
            this.Message = message;
            this.AlertType = alertType;
        }
        /// <summary>
        /// Ruft die Nachricht des Alerts ab, oder legt diese fest.
        /// </summary>
        public string Message { get; set; } = String.Empty;
        /// <summary>
        /// Ruft den Bootstrap AlertType des Alerts ab, oder legt diesen fest.
        /// </summary>
        public AlertType AlertType { get; set; }
        /// <summary>
        /// Gibt an, wie lange das Alert angezeigt werden soll.
        /// <para>
        /// 0 = permanent anzeigen.
        /// </para>
        /// </summary>
        public int DecayTime { get; set; } = 0;
    }
}
