﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;

namespace WK5.Core
{
    /// <summary>
    /// Die Alte ArtikelNamensKlasse aus ArtikelUpdateOpencart. 1:1 Kopie
    /// </summary>
    public class ArtikelNamensKlasse
    {
        public string Name1 = "", Name2 = "", Name3 = "", Name4 = "", Name5 = "";
        private int MaxZeichen;

        /// <summary>
        /// Filtert Sonderzeichen aus dem Namen des Artikels und splittet diese bei der angegebenen Länge
        /// </summary>
        /// <param name="Artikelname"></param>
        /// <param name="ZeichenproZeile">nach wie vielen zeichen soll gesplittet werden</param>
        public ArtikelNamensKlasse(string Artikelname, int ZeichenproZeile)
        {
            this.MaxZeichen = ZeichenproZeile;
            string HilfsString = "";
            Boolean IstVerarbeitet = false;

            //public static KarleyLibrary.KarleyEmailKlasse EmailSender2 = new KarleyLibrary.KarleyEmailKlasse(KarleyLibrary.KarleyEmailKlasse.EmailDienst.David);
            //Sonderzeichen aus dem ggf. Web entfernen und Leerzeichen etc.
            Artikelname = System.Net.WebUtility.HtmlDecode(Artikelname);
            Artikelname = Artikelname.Replace("&nbsp;", "").Replace("&quot;", "").Replace("&amp;", "");

            Artikelname = Regex.Replace(Artikelname, @"<[^>]*>", " "); // HTML TAGS gegen leerzeichen austauschen
            Artikelname = Regex.Replace(Artikelname, "[ ]{2,}", " "); // Doppelte Leerzeichen entfernen
            Artikelname = Regex.Replace(Artikelname, "[^a-zA-Z0-9-,-;-//-ü-Ü-ö-Ö-ü-Ü-ß-@\"]", " "); // Alle Sonderzeichen Raus Zahle, Umlaute etc. bleiben!

            Artikelname = Artikelname.Trim();
            Artikelname = StringErweiterung.RemoveMultipleCharOccurence(Artikelname, ' ');

            //Anfang komma löschen
            if (Artikelname.EndsWith(","))
            {
                Artikelname = Artikelname.Remove(Artikelname.Length - 1, 1);
            }

            if (Artikelname.StartsWith(","))
            {
                Artikelname = Artikelname.Remove(0, 1);
            }

            if (Artikelname.Length > ZeichenproZeile)
            {
                Name1 = this.SplitWords(Artikelname);
                HilfsString = Artikelname.Substring(Name1.Length + 1);
            }
            else
            {
                Name1 = Artikelname;
                HilfsString = "";
                IstVerarbeitet = true;
            }
            if (HilfsString.EndsWith(","))
            {
                HilfsString = HilfsString.Remove(HilfsString.Length - 1, 1);
            }

            if (HilfsString.StartsWith(","))
            {
                HilfsString = HilfsString.Remove(0, 1);
            }

            if (HilfsString.StartsWith(" "))
            {
                HilfsString = HilfsString.Remove(0, 1);
            }

            if (HilfsString.EndsWith(" "))
            {
                HilfsString = HilfsString.Remove(HilfsString.Length - 1, 1);
            }

            if (HilfsString.Length > ZeichenproZeile && IstVerarbeitet == false)
            {
                Name2 = SplitWords(HilfsString);
                HilfsString = HilfsString.Substring(Name2.Length + 1);
            }
            else if (HilfsString.Length > 0 && IstVerarbeitet == false)
            {
                Name2 = HilfsString;
                HilfsString = "";
                IstVerarbeitet = true;
            }
            if (HilfsString.EndsWith(","))
            {
                HilfsString = HilfsString.Remove(HilfsString.Length - 1, 1);
            }

            if (HilfsString.StartsWith(","))
            {
                HilfsString = HilfsString.Remove(0, 1);
            }

            if (HilfsString.StartsWith(" "))
            {
                HilfsString = HilfsString.Remove(0, 1);
            }

            if (HilfsString.EndsWith(" "))
            {
                HilfsString = HilfsString.Remove(HilfsString.Length - 1, 1);
            }

            if (HilfsString.Length > ZeichenproZeile && IstVerarbeitet == false)
            {
                Name3 = SplitWords(HilfsString);
                HilfsString = HilfsString.Substring(Name3.Length + 1);
            }
            else if (HilfsString.Length > 0 && IstVerarbeitet == false)
            {
                Name3 = HilfsString;
                HilfsString = "";
                IstVerarbeitet = true;
            }
            if (HilfsString.EndsWith(","))
            {
                HilfsString = HilfsString.Remove(HilfsString.Length - 1, 1);
            }

            if (HilfsString.StartsWith(","))
            {
                HilfsString = HilfsString.Remove(0, 1);
            }

            if (HilfsString.StartsWith(" "))
            {
                HilfsString = HilfsString.Remove(0, 1);
            }

            if (HilfsString.EndsWith(" "))
            {
                HilfsString = HilfsString.Remove(HilfsString.Length - 1, 1);
            }

            if (HilfsString.Length > ZeichenproZeile && IstVerarbeitet == false)
            {
                Name4 = SplitWords(HilfsString);
                HilfsString = HilfsString.Substring(Name4.Length + 1);
            }
            else if (HilfsString.Length > 0 && IstVerarbeitet == false)
            {
                Name4 = HilfsString;
                HilfsString = "";
                IstVerarbeitet = true;
            }
            if (HilfsString.EndsWith(","))
            {
                HilfsString = HilfsString.Remove(HilfsString.Length - 1, 1);
            }

            if (HilfsString.StartsWith(","))
            {
                HilfsString = HilfsString.Remove(0, 1);
            }

            if (HilfsString.StartsWith(" "))
            {
                HilfsString = HilfsString.Remove(0, 1);
            }

            if (HilfsString.EndsWith(" "))
            {
                HilfsString = HilfsString.Remove(HilfsString.Length - 1, 1);
            }

            if (HilfsString.Length > ZeichenproZeile && IstVerarbeitet == false)
            {
                Name5 = SplitWords(HilfsString);
                HilfsString = HilfsString.Substring(Name5.Length + 1);
            }
            else if (HilfsString.Length > 0 && IstVerarbeitet == false)
            {
                Name5 = HilfsString.Trim();
                HilfsString = "";
                IstVerarbeitet = true;
            }

        }
        /// <summary>
        /// Die Funktion splittet die Artikelbezeichnung nach spätestens der angebenen MaxZeichen und frühstens vor dem letzten Leerzeichen im angegebenen Intervall
        /// </summary>
        /// <param name="_artikelname"></param>
        /// <returns></returns>
        private string SplitWords(string _artikelname)
        {
            string tempName = _artikelname.Substring(0, this.MaxZeichen);
            int posLeerzeichen = tempName.LastIndexOf(" ");
            if (posLeerzeichen >= 0)
            {
                tempName = tempName.Substring(0, posLeerzeichen);
            }

            return tempName;
        }
    }
}
