﻿using System;
using System.Collections.Generic;
using WK5.Core.Models;

namespace WK5.Core
{
    /// <summary>
    /// Stellt den eingeloggten Mitarbeiter der WK5 dar.
    /// </summary>
    public class AppMitarbeiter
    {
        public string Username { get; set; } = String.Empty;
        public List<string> Gruppen { get; set; } = new List<string>();
        public string DisplayName { get; set; } = String.Empty;
        /// <summary>
        /// Ruft die zugehörige Personalnummer des Mitarbeiters aus der W4 ab.
        /// </summary>
        public int PersonalNummer { get; set; }

        public string Passwort { get; set; } = String.Empty;

        public bool IsMoneyDecisionUser { get; set; }
        public bool IsAdmin { get; set; }
        public bool IsBuchhaltung { get; set; }
        public bool IsTechnik { get; set; }
        public List<Gruppe> WK5Gruppen { get; set; } = new List<Gruppe>();
        public string? Telefonnummer { get; set; }
        public string? Email { get; set; }

        /// <summary>
        /// Dieses Flag ist für die automatische Anzeige des Keyboards auf mobilen Geräten.
        /// </summary>
        public bool ShowMobileKeyboard { get; set; }
    }
}
