﻿using Microsoft.Extensions.Configuration;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Threading.Tasks;
using WK5.Core.Email;

namespace WK5.Core
{
    public class AppConfiguration
    {
        private readonly IConfiguration _configuration;

        public AppConfiguration(IConfiguration configuration)
        {
            _configuration = configuration;
            CheckDokumentenAblage();
        }

        public string LDAP
        {
            get
            {
                return _configuration["Login:LDAP"];
            }
        }

        public string DomainServer
        {
            get
            {
                return _configuration["Login:DOMAIN_SERVER"];
            }
        }

        public string OutputPfad
        {
            get
            {
                return _configuration["Pfade:OutputPfad"];
            }
        }

        public string DokumentenAblagePfad
        {
            get
            {
                return _configuration["Pfade:DokumentenAblage"];
            }
        }

        public string KundenDokumentenAblagePfad
        {
            get
            {
                return _configuration["Pfade:KundenDokumentenAblage"];
            }
        }

        public string LieferantenDokumentenAblagePfad
        {
            get
            {
                return _configuration["Pfade:LieferantenDokumentenAblage"];
            }
        }

        public string ArtikelDokumentenAblagePfad
        {
            get
            {
                return _configuration["Pfade:ArtikelDokumentenAblage"];
            }
        }

        public string AngebotDokumentenAblagePfad
        {
            get
            {
                return _configuration["Pfade:AngebotDokumentenAblage"];
            }
        }

        public string AuftragDokumentenAblagePfad
        {
            get
            {
                return _configuration["Pfade:AuftragDokumentenAblage"];
            }
        }

        public string LieferscheinDokumentenAblagePfad
        {
            get
            {
                return _configuration["Pfade:LieferscheinDokumentenAblage"];
            }
        }

        public string RechnungDokumentenAblagePfad
        {
            get
            {
                return _configuration["Pfade:RechnungDokumentenAblage"];
            }
        }

        public string GutschriftDokumentenAblagePfad
        {
            get
            {
                return _configuration["Pfade:GutschriftDokumentenAblage"];
            }
        }
        public string RmaDokumentenAblagePfad
        {
            get
            {
                return _configuration["Pfade:RmaDokumentenAblage"];
            }
        }

        public string BestellungenDokumentenAblagePfad
        {
            get
            {
                return _configuration["Pfade:BestellungenDokumentenAblage"];
            }
        }
        public string PackbilderPfad
        {
            get
            {
                return _configuration["Pfade:PackbilderPfad"];
            }
        }

        public string OutputUrl
        {
            get
            {
                return _configuration["Pfade:OutputUrl"];
            }
        }

        public string ArchivPfad
        {
            get
            {
                return _configuration["Pfade:ArchivPfad"];
            }
        }

        public string ScanInputPfad
        {
            get
            {
                return _configuration["Pfade:ScanInputPfad"];
            }
        }

        public FirmenDaten FirmenDaten
        {
            get
            {
                return _configuration.GetSection("Firmendaten").Get<FirmenDaten>();              
            }
        }

        public bool IsWartungEnabled
        {
            get
            {
                return _configuration.GetValue<bool>("Wartungen:Enabled");
            }
        }

        public string WartungsAbsender
        {
            get
            {
                return _configuration["Wartungen:Absender"];
            }
        }

        public string WartungAbsenderName
        {
            get
            {
                return _configuration["Wartungen:AbsenderName"];
            }
        }

        public bool ZeiterfassungEnabled
        {
            get
            {
                return _configuration.GetValue<bool>("Zeiterfassung:Enabled");
            }
        }

        public bool UseDezimalzeit
        {
            get
            {
                return _configuration.GetValue<bool>("Zeiterfassung:UseDezimalzeit");
            }
        }

        public bool UseZeiteinheiten
        {
            get
            {
                return _configuration.GetValue<bool>("Zeiterfassung:UseZeiteinheiten");
            }
        }

        public int ZeiteinheitInMinuten
        {
            get
            {
                return _configuration.GetValue<int>("Zeiterfassung:ZeiteinheitInMinuten");
            }
        }

        public MailCredentials SMTPIntern
        {
            get
            {
                return _configuration.GetSection("Mail").GetSection("SMTP").GetSection("Intern").Get<MailCredentials>();
            }
        }

        public MailCredentials SMTPExtern
        {
            get
            {
                return _configuration.GetSection("Mail").GetSection("SMTP").GetSection("Extern").Get<MailCredentials>();
            }
        }

        public MailCredentials David
        {
            get
            {
                return _configuration.GetSection("Mail").GetSection("David").Get<MailCredentials>();
            }
        }

        private void CheckDokumentenAblage()
        {
            if (!string.IsNullOrWhiteSpace(OutputPfad) && !Directory.Exists(OutputPfad))
            {
                Directory.CreateDirectory(OutputPfad);
            }


            if (!string.IsNullOrWhiteSpace(DokumentenAblagePfad) && !Directory.Exists(DokumentenAblagePfad))
            {
                Directory.CreateDirectory(DokumentenAblagePfad);
            }

            if (!string.IsNullOrWhiteSpace(KundenDokumentenAblagePfad) && !Directory.Exists(KundenDokumentenAblagePfad))
            {
                Directory.CreateDirectory(KundenDokumentenAblagePfad);
            }

            if (!string.IsNullOrWhiteSpace(LieferantenDokumentenAblagePfad) && !Directory.Exists(LieferantenDokumentenAblagePfad))
            {
                Directory.CreateDirectory(LieferantenDokumentenAblagePfad);
            }

            if (!string.IsNullOrWhiteSpace(ArtikelDokumentenAblagePfad) && !Directory.Exists(ArtikelDokumentenAblagePfad))
            {
                Directory.CreateDirectory(ArtikelDokumentenAblagePfad);
            }

            if (!string.IsNullOrWhiteSpace(AngebotDokumentenAblagePfad) && !Directory.Exists(AngebotDokumentenAblagePfad))
            {
                Directory.CreateDirectory(AngebotDokumentenAblagePfad);
            }

            if (!string.IsNullOrWhiteSpace(AuftragDokumentenAblagePfad) && !Directory.Exists(AuftragDokumentenAblagePfad))
            {
                Directory.CreateDirectory(AuftragDokumentenAblagePfad);
            }

            if (!string.IsNullOrWhiteSpace(LieferscheinDokumentenAblagePfad) && !Directory.Exists(LieferscheinDokumentenAblagePfad))
            {
                Directory.CreateDirectory(LieferscheinDokumentenAblagePfad);
            }

            if (!string.IsNullOrWhiteSpace(RechnungDokumentenAblagePfad) && !Directory.Exists(RechnungDokumentenAblagePfad))
            {
                Directory.CreateDirectory(RechnungDokumentenAblagePfad);
            }

            if (!string.IsNullOrWhiteSpace(GutschriftDokumentenAblagePfad) && !Directory.Exists(GutschriftDokumentenAblagePfad))
            {
                Directory.CreateDirectory(GutschriftDokumentenAblagePfad);
            }

            if (!string.IsNullOrWhiteSpace(RmaDokumentenAblagePfad) && !Directory.Exists(RmaDokumentenAblagePfad))
            {
                Directory.CreateDirectory(RmaDokumentenAblagePfad);
            }

            if (!string.IsNullOrWhiteSpace(BestellungenDokumentenAblagePfad) && !Directory.Exists(BestellungenDokumentenAblagePfad))
            {
                Directory.CreateDirectory(BestellungenDokumentenAblagePfad);
            }
        }




    }
}
