﻿function closeModal(modal_id) {
    $(modal_id).modal('hide');
}

function showToast(type, message, timeout = 5000) {
    if (timeout == -1)
        timeout = null;
    toastr.options = {
        "closeButton": false,
        "debug": false,
        "newestOnTop": true,
        "progressBar": true,
        "positionClass": "toast-bottom-right",
        "preventDuplicates": false,
        "onclick": null,
        "showDuration": "300",
        "hideDuration": "1000",
        "timeOut": timeout,
        "extendedTimeOut": "1000",
        "showEasing": "swing",
        "hideEasing": "linear",
        "showMethod": "fadeIn",
        "hideMethod": "fadeOut"
    };


    switch (type) {
        case "warning":
            toastr.warning(message);
            break;
        case "error":
            toastr.error(message);
            break;
        default:
            toastr.success(message);
            break;
    }

}

window.blazorHelpers = {
    scrollToFragment: (elementId) => {
        var element = document.getElementById(elementId);

        if (element) {
            element.scrollIntoView({
                behavior: 'smooth'
            });
        }
    },
    selectDefaultIndex: (element) => {
        element.selectedIndex = 0;
    },
    showSweetAlert: (icon, title, html, timer) => {
        Swal.fire({
            icon: icon,
            title: title,
            html: html,
            timer: timer
        });
    },
    setDocumentTitle: (title) => {
        document.title = title;
    },
    showToast: (type, message, timeout = 5000) => {
        toastr.options = {
            "closeButton": false,
            "debug": false,
            "newestOnTop": true,
            "progressBar": true,
            "positionClass": "toast-bottom-right",
            "preventDuplicates": false,
            "onclick": null,
            "showDuration": "300",
            "hideDuration": "1000",
            "timeOut": timeout,
            "extendedTimeOut": "1000",
            "showEasing": "swing",
            "hideEasing": "linear",
            "showMethod": "fadeIn",
            "hideMethod": "fadeOut"
        };


        switch (type) {
            case "warning":
                toastr.warning(message);
                break;
            case "error":
                toastr.error(message);
                break;
            default:
                toastr.success(message);
                break;
        }
    },
    setFocus: (element) => {
        element.setFocus();
    },
    setFocusById: (elementId) => {
        var element = document.getElementById(elementId);
        if (element) {
            element.focus();
        }
    },
    open: (url) => {
        window.open(url, '_blank');
    },
    addTooltips: () => {
        $('[data-toggle="tooltip"]').tooltip({
            trigger: 'hover'
        });
        $('[data-toggle="tooltip"]').on('mouseleave', function () {
            $(this).tooltip('hide');
        });
        $('[data-toggle="tooltip"]').on('click', function () {
            $(this).tooltip('dispose');
        });
    }


};

/*
 * Sorgt dafür das sich das Menü beim clicken eines Nav Links wieder automatisch schließt
 */

$(document).on("click", "nav .nav a:not([data-bs-toggle])", function () {    
    var w = $(window).width();
    // Soll nur bei Mobile Geräten funktionieren
    if (w <= 991) {


        var t = $(this).attr("data-toggle");

        if (t != "collapse") {
            $("body").toggleClass("sb-sidenav-toggled");
        }
    }

});

