using Microsoft.AspNetCore.Hosting;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Hosting;
using Serilog;
using System;
using System.Diagnostics;
using System.IO;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Models;
using WK5.Core.Services;

namespace WK5_Blazor
{
    public class Program
    {
        public static readonly Version Wk5Version = new Version(5, 17, 0);
#nullable disable
        public static AppDaten AppDaten;
        public static AppConfiguration Configuration;
#nullable enable

        

        public static async Task Main(string[] args)
        {
            //Hier werden alle Hilfsdaten (Rabattbezeichnungen / Kundengruppen initialisiert .. bei neuen hier rein und fixen.
            AppDaten = await AppDaten.CreateAsync();

            if (!Directory.Exists(ArtikelDokument.DokumentenRoot))
            {
                Directory.CreateDirectory(ArtikelDokument.DokumentenRoot);
            }
                      
            var host = CreateHostBuilder(args).Build();

            await host.Services.GetRequiredService<NotificationService>().Initialize();
            await host.Services.GetRequiredService<NotificationService>().RunTimer();

            host.Run();
        }

        public static IHostBuilder CreateHostBuilder(string[] args)
        {
            return Host.CreateDefaultBuilder(args)
                .ConfigureAppConfiguration((context, config) =>
                {
                    var env = context.HostingEnvironment;
                    config.AddJsonFile(Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "appSettings.json"), false);
                    config.AddJsonFile(Path.Combine(AppDomain.CurrentDomain.BaseDirectory, $"appSettings.{env.EnvironmentName}.json"), true);
                    config.AddJsonFile(Path.Combine(AppDomain.CurrentDomain.BaseDirectory, $"appSettings.klein.json"), true);
                })
                .ConfigureWebHostDefaults(webBuilder =>
                {
                    
                    webBuilder.UseStartup<Startup>();
                });
        }



    }
}
