﻿using Microsoft.AspNetCore.Components;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis.Erweiterungen;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;
using WK5.Core.Validators.Verkauf.Wartungen;

namespace WK5_Blazor.Pages.Verkauf.Wartungen
{
    public partial class WartungsÜbersicht : IHasPageFilter, IAsyncDisposable
    {
#nullable disable

        [CascadingParameter] public AppMitarbeiter Mitarbeiter { get; set; }
#nullable enable
        [Parameter] public int Seite { get => _seite; set => _seite = value < 1 ? 1 : value; }
        public WartungFilter Filter { get; set; } = new WartungFilter();
        public int TotalItems { get; set; }
        private List<Wartung> _wartungen = new List<Wartung>();
        private int _seite = 1;
        private bool _lädt;
        private CancellationTokenSource _cts = new CancellationTokenSource();
        private Wartung? _neueWartung;
        private ManuelleWartungValidator _validator = new ManuelleWartungValidator();
        private bool _isDisposed;

        public ArtikelFilter FilterArtikelWartungAnlage { get; set; } = new ArtikelFilter
        {
            NurArtikelMitLagerführung = true,
            ZeigeInaktive = true
        };

        protected override async Task OnParametersSetAsync()
        {
            await LadeAsync();
        }

        private Task ResetFilterAsync()
        {
            Filter = new WartungFilter();
            return Task.CompletedTask;
        }

        private Task NewWartungAsync()
        {
            _neueWartung = new Wartung
            {
                ManuelleWartung = true,
                Anlagedatum = DateTime.Now
            };

            return Task.CompletedTask;
        }

        private async Task WartungsKundeSelectedAsync(Kunde kunde)
        {
            if (_neueWartung is not null)
            {
                if (kunde.KeineWartungen)
                {
                    await jsRuntime.ShowToast(ToastType.error, $"Dieser Kunde kann nicht ausgewählt werden, da für Ihn das Flag keine Wartungen gesetzt ist!!!");
                    return;
                }
                _neueWartung.Kundennummer = kunde.KUND_A_NR;
                _neueWartung.Kundenname = kunde.KUND_A_NAME1;
            }
        }
        private async Task WartungsArtikelSelectedAsync(Artikel artikel)
        {
            if (_neueWartung is not null)
            {
                if (!artikel.ARTI_L_SN)
                {
                    await jsRuntime.ShowToast(ToastType.error, "Artikel kann nicht ausgewählt werden, da er über keine Seriennummerverwaltung verfügt!!!");
                    return;
                }

                _neueWartung.Artikelnummer = artikel.Artikelnummer;
            }
        }

        private async Task CreateWartungAsync()
        {
            if (_neueWartung is not null)
            {
                using FbController2 fbController = new FbController2(Mitarbeiter.PersonalNummer);

                await wartungsService.CreateAsync(_neueWartung, fbController);
                await AddAlertAsync(new WK5.Core.Basis.AlertBox
                {
                    AlertType = WK5.Core.Basis.AlertType.Success,
                    Message = "Wartung wurde erfolgreich angelegt"
                });
                navigationManager.NavigateTo($"/Wartungen/{_neueWartung.WartungsNr}");
                _neueWartung = null;
            }
        }
        private async Task LadeAsync()
        {
            _cts.Cancel();
            _cts.Dispose();
            _cts = new CancellationTokenSource();
            var token = _cts.Token;
            Filter.Seite = Seite;
            _wartungen.Clear();
            using FbController2 fbController = new FbController2();
            _lädt = true;
            try
            {
                await foreach (var item in wartungsService.GetWartungenAsync(Filter, fbController, token))
                {
                    _wartungen.Add(item);
                    StateHasChanged();
                }

                TotalItems = await wartungsService.GetAnzahlWartungenAsync(Filter, fbController, token);
            }
            catch (OperationCanceledException) { }

            _lädt = false;
        }

        private string GetRowClass(Wartung wartung)
        {
            if (wartung.Erledigt)
            {
                return "table-success";
            }

            return string.Empty;
        }

        public override ValueTask DisposeAsync()
        {
            _isDisposed = true;
            _cts.Cancel();
            _cts.Dispose();
            return base.DisposeAsync();
        }
    }
}
