using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.RazorPages;
using WK5.Core;
using WK5.Core.Drucken;
using WK5.Core.Drucken.Angebote;
using WK5.Core.Drucken.Auftrge;
using WK5.Core.Drucken.Gutschriften;
using WK5.Core.Drucken.Lieferscheine;
using WK5.Core.Drucken.Rechnungen;
using WK5.Core.Models;

namespace WK5_Blazor.Pages.Verkauf
{
    public class VorschauModel : PageModel
    {
        public async Task<IActionResult> OnGetAsync(BelegTyp belegTyp, int belegnummer)
        {
            using FbController2 fbController = new FbController2();
            
            
            var beleg = await Beleg.GetBelegAsync(belegTyp, belegnummer, fbController);

            if (beleg is not null)
            {
                PrintBase printer = belegTyp switch
                {
                    BelegTyp.Angebot => await PrintAngebot.CreateAsync((Angebot)beleg, new PrintAngebotRegelsatz { ShowHeader = true, ShowFooter = true }, fbController),
                    BelegTyp.Auftrag => await PrintAuftrag.CreateAsync((Auftrag)beleg, new PrintAuftragRegelsatz { ShowHeader = true, ShowFooter = true }, fbController),
                    BelegTyp.Lieferschein => await PrintLieferschein.CreateAsync((Lieferschein)beleg, new PrintLieferscheinRegelsatz { ShowHeader = true, ShowFooter = true }),
                    BelegTyp.Rechnung => await PrintRechnung.CreateAsync((Rechnung)beleg, new PrintRechnungRegelsatz { ShowHeader = true, ShowFooter = true }, fbController),
                    BelegTyp.Gutschrift => await PrintGutschrift.CreateAsync((Gutschrift)beleg, new PrintGutschriftRegelsatz { ShowHeader = true, ShowFooter = true }, fbController),
                    _ => throw new ArgumentOutOfRangeException(nameof(belegTyp))
                };

                if (belegTyp is BelegTyp.Lieferschein && beleg.NeutralerVersender && beleg.NeutralerLieferschein.Length > 0)
                {
                    return File(beleg.NeutralerLieferschein, "application/pdf");
                }
                else
                {
                    string filename = printer.Print(GlobalConfig.Configuration.OutputPfad);
                    return File(await System.IO.File.ReadAllBytesAsync(filename), "application/pdf");
                }
            }

            return Page();
        }
    }
}
