﻿using Microsoft.AspNetCore.Components;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;

namespace WK5_Blazor.Pages.Verkauf.Rechnungen
{
    public partial class WiederkehrendeRechnungen : IAsyncDisposable, IHasPageFilter
    {

        [Parameter] public int Seite { get => _seite; set => _seite = value <= 0 ? 1 : value; }
        private List<WiederkehrendeRechnung> Items { get; set; } = new List<WiederkehrendeRechnung>();
        public WiederkehrendeRechnungenFilter Filter { get; set; } = new WiederkehrendeRechnungenFilter();
        public int TotalItems { get; set; }

        private CancellationTokenSource _cts = new CancellationTokenSource();
        private bool _lädt;
        private int _seite = 1;
        protected override async Task OnParametersSetAsync()
        {
            await SetAlerts();
            await LadeAsync();
        }
        
        private async Task LadeAsync()
        {
            _cts.Cancel();
            _cts.Dispose();
            _cts = new CancellationTokenSource();
            var token = _cts.Token;
            _lädt = true;

            Filter.Seite = Seite;
            using FbController2 fbController = new FbController2();
            Items.Clear();
            try
            {
                await foreach (var item in wiederkehrendeRechnungenService.GetWiederkehrendeRechnungenAsync(Filter, fbController, token))
                {
                    Items.Add(item);
                    StateHasChanged();
                }

                TotalItems = await wiederkehrendeRechnungenService.GetAnzahlWiederkehrendeRechnungenAsync(Filter, fbController, token);
                
            }
            catch (OperationCanceledException) { }
            _lädt = false;
        }

        public override ValueTask DisposeAsync()
        {
            _cts?.Cancel();
            _cts?.Dispose();
            return ValueTask.CompletedTask;
        }
    }
}
