﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;

namespace WK5_Blazor.Pages.Verkauf.Rechnungen
{
    public partial class OffeneRechnungen : IAsyncDisposable
    {
        public OffeneRechnungenFilter Filter { get; set; } = new OffeneRechnungenFilter();
        private List<OffeneRechnung> _results = new();
        private CancellationTokenSource _cts = new CancellationTokenSource();
        private bool _lädt;

        protected override async Task OnInitializedAsync()
        {
            await LadeAsync();
        }
        private async Task LadeAsync()
        {
            _cts.Cancel();
            _cts.Dispose();
            _cts = new CancellationTokenSource();
            var token = _cts.Token;
            _results.Clear();
            _lädt = true;
            using FbController2 fbController = new FbController2();

            try
            {
                await foreach (var item in belegService.GetOffeneRechnungen(Filter, fbController, token))
                {
                    _results.Add(item);
                    StateHasChanged();
                }
            }
            catch (OperationCanceledException){}
            _lädt = false;
        }

        public ValueTask DisposeAsync()
        {
            _cts?.Cancel();
            _cts?.Dispose();
            return ValueTask.CompletedTask;
        }
    }
}
