﻿using Microsoft.AspNetCore.Components;
using Microsoft.AspNetCore.Components.Forms;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis.Erweiterungen;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;
using WK5.Core.Models.Versand;
using WK5.Core.PageModels;
using WK5.Core.PageModels.Tools.Versand;
using WK5.Core.PageModels.Verkauf.RMAS;

namespace WK5_Blazor.Pages.Verkauf.RMAS
{
    public partial class RmaVersand : ITabView<RmaVersandTab>
    {
        [Parameter] public int RmaNummer { get; set; }

        [Parameter] public RmaVersandTab ActiveTab { get; set; }
        public RmaVersandInput Input { get; set; } = new RmaVersandInput();

        public PaketFilter Filter { get; set; } = new PaketFilter
        {
            Typ = PaketTyp.RMA
        };

        private EditForm? _versandForm;
        private bool _isLoading;
        protected override Task OnParametersSetAsync()
        {
            Filter.Nummer = RmaNummer.ToString();
            return Task.CompletedTask;
        }
        private async Task VersandErstellenAsync(bool zumLieferanten)
        {
            _isLoading = true;
            if (_versandForm is null || _versandForm.EditContext is null)
            {
                return;
            }

            if(_versandForm.EditContext.Validate())
            {
                using FbController2 fbController = new FbController2();
                DruckRma rma = await DruckRma.GetDruckRmaAsync(RmaNummer, fbController) ?? throw new NullReferenceException(nameof(rma));

                var (erfolgreich, successResponses, alerts) = await versandService.PaketeEintragenAsync(rma, Input.Pakete, zumLieferanten, new VersandOption(Courier.UPS, Input.CourierArt), fbController);
                
                await AddAlertsAsync(alerts);
                await SetAlerts();
             

                if(erfolgreich)
                {
                    await jsRuntime.ShowToast(ToastType.success, "Sendung wurde erfolgreich eingetragen", 3000);
                }
                else
                {
                    await jsRuntime.ShowToast(ToastType.success, "Fehler beim eintragen der Pakete. Es wurde ein Fehlerbericht an den Vertrieb gesendet.", 5000);
                }

                Input = new RmaVersandInput();
                
            }

            _isLoading = false;
        }
        public string GetNavListClass(bool isActive) => isActive ? "nav-link edit-page-nav-link active" : "nav-link edit-page-nav-link";
        public string GetTabClass(bool isActive) => isActive ? "tab-pane fade show active" : "tab-pane fade";
    }
}
