﻿using Microsoft.AspNetCore.Components;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis;
using WK5.Core.Basis.Erweiterungen;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;
using WK5.Core.Models.Services;
using WK5.Core.PageModels.Verkauf.Lieferscheine;

namespace WK5_Blazor.Pages.Verkauf.Lieferscheine
{
    public partial class OhneBerechnung : IHasPageFilter
    {

        [Parameter] public int Seite { get => _seite; set => _seite = value < 1 ? 1 : value; }
        public int TotalItems { get; set; }
        private LieferscheinOhneBerechnung? _selectedLieferscheinOhneBerechnung;
        private OhneBerechnungInput _genehmigenInput = new OhneBerechnungInput();
        private CancellationTokenSource cancellationToken = new CancellationTokenSource();
        private List<LieferscheinOhneBerechnung> Items { get; set; } = new List<LieferscheinOhneBerechnung>();
        public LieferscheinOhneBerechnungFilter Filter { get; set; } = new LieferscheinOhneBerechnungFilter();
        public OhneBerechnungAuswertungFilter FilterAuswertung { get; set; } = new OhneBerechnungAuswertungFilter();

        private int _seite;
        private Rma? _rma;
        private bool _showAuswertungModal;
        private bool _auswertungIsLoading;

#nullable disable
        [CascadingParameter] public AppMitarbeiter Mitarbeiter { get; set; }
#nullable enable
        private async Task SwitchSucheAsync()
        {
            Filter.ZeigeGenehmigte = !Filter.ZeigeGenehmigte;

            await LoadItems();
        }
        protected override async Task OnParametersSetAsync()
        {
            await LoadItems();
        }

        private async Task LoadItems(bool navigateToPage1 = false)
        {
            if (navigateToPage1)
            {
                Seite = 1;
            }
            
            using FbController2 fbController = new FbController2();
            Filter.Seite = Seite;
            Items = await belegService.GetLieferscheineOhneBerechnungAsync(Filter, fbController).ToListAsync();
            TotalItems = await belegService.GetLieferscheineOhneBerechnungAnzahlAsync(Filter, fbController);
        }

        private async Task GenehmigenAsync()
        {
            if (_selectedLieferscheinOhneBerechnung is not null)
            {
                using FbController2 fbController = new FbController2(Mitarbeiter.PersonalNummer);
                await fbController.StartTransactionAsync();
                try
                {
                    await belegService.LieferscheinOhneBerechnungGenehmigenAsync(_selectedLieferscheinOhneBerechnung, _genehmigenInput, fbController);
                    await fbController.CommitChangesAsync();
                    await jsRuntime.ShowToast(ToastType.success, $"Lieferschein {_selectedLieferscheinOhneBerechnung.BELE_N_NR} wurde erfolgreich ohne Berechnung genehmigt.");
                }
                catch (System.Exception)
                {
                    await fbController.RollbackChangesAsync();
                    throw;
                }

                Items.Remove(_selectedLieferscheinOhneBerechnung);
                _selectedLieferscheinOhneBerechnung = null;
                _genehmigenInput = new OhneBerechnungInput();
            }
        }

        private async Task AuswertenAsync()
        {
            _auswertungIsLoading = true;
            using FbController2 fbController = new FbController2();
            List<AuswertungOhneBerechnung> data = await belegService.GetAuswertungOhneBerechnungAsync(FilterAuswertung, fbController);

            if (data.Any())
            {
                StringBuilder sb = new StringBuilder();
                sb.AppendLine("Lieferschein;Begründung;Erlöskonto;Genehmigt durch;EK");
                foreach (var item in data)
                {
                    sb.AppendLine($"{item.BELE_N_NR};{item.BELE_A_OHNE_BERECHNUNG_GRUND};{item.BELE_A_ERLOESKONTO};{Program.AppDaten.GetMitarbeiterName(item.BCNG_N_USER)};{item.EK}");
                }

                await downloadService.DownloadFileFromText("ohne_berechnung_auswertung.csv", sb.ToString(), Encoding.UTF8,"text/csv");
                await downloadService.ClearBuffers();
            }
            else
            {
                await jsRuntime.ShowToast(ToastType.error, "Es wurden keine Belege gefunden");
            }
            _auswertungIsLoading = false;
        }
        private async Task SelectLieferscheinZuGenehmigenAsync(LieferscheinOhneBerechnung? lieferschein)
        {
            if(lieferschein is null)
            {
                _selectedLieferscheinOhneBerechnung = null;
                _rma = null;
            }
            else
            {
                _selectedLieferscheinOhneBerechnung = lieferschein;
                if(lieferschein.BELE_N_NR_RMA > 0)
                {
                    using FbController2 fbController = new FbController2();
                    _rma = await rmaService.GetAsync(lieferschein.BELE_N_NR_RMA, fbController);
                }
                else
                {
                    _rma = null;
                }
            }
        }
        
    }
}
