﻿using Microsoft.AspNetCore.Components;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis;
using WK5.Core.Models;
using WK5.Core.Models.Tools.Lagerregal;

namespace WK5_Blazor.Pages.Verkauf.Aufträge
{
    public partial class TeillieferungsFreigabe
    {
        [Parameter] public int Auftragsnummer { get; set; }
#nullable disable
        [CascadingParameter] public AppMitarbeiter Mitarbeiter { get; set; }
#nullable enable
        private PackAuftrag? _auftrag;


        protected override async Task OnParametersSetAsync()
        {
            using FbController2 fbController = new FbController2();
            _auftrag = await PackAuftrag.GetPackAuftragAsync(Auftragsnummer, fbController);
            if (_auftrag is not null)
            {
                string suffix;
                if (_auftrag.AuftragInFreigabe)
                {
                    suffix = "Der Auftrag ist bereits in der Freigabe!";
                }
                else if (_auftrag.BELE_L_ERLEDIGT)
                {
                    suffix = "Der Auftrag ist bereits erledigt!";
                }
                else if (_auftrag.BELE_L_STORNO)
                {
                    suffix = "Der Auftrag ist storniert!";
                }
                else if (_auftrag.WK5_BELE_L_PAUSIERT)
                {
                    suffix = "Der Auftrag ist pausiert!";
                }
                else if (_auftrag.WK5_BELE_L_DIREKTLIEFERUNG)
                {
                    suffix = "Der Auftrag ist eine Direktlieferung!";
                }
                else
                {
                    suffix = String.Empty;
                }

                if (!String.IsNullOrWhiteSpace(suffix))
                {
                    await AddAlertAsync(new AlertBox
                    {
                        AlertType = AlertType.Danger,
                        Message = $"Auftrag {Auftragsnummer} darf nicht freigegeben werden. {suffix}"
                    });

                    navigationManager.NavigateTo("/Auftraege");
                }
            }
            else
            {
                await AddAlertAsync(new AlertBox
                {
                    AlertType = AlertType.Danger,
                    Message = $"Auftrag {Auftragsnummer} konnte nicht gefunden werden."
                });

                navigationManager.NavigateTo("/Auftraege");
            }
        }

        public async Task AuftragFreigebenAsync()
        {
            using FbController2 fbController = new FbController2(Mitarbeiter.PersonalNummer);

            if (_auftrag is not null)
            {
                Belegposition pos = new Belegposition();
                pos.BPOS_N_NR = _auftrag.Belegnummer;
                pos.BPOS_A_TYP = _auftrag.Belegtyp;
                pos.Artikelnummer = Belegposition.ARTIKELNR_TEXT;
                pos.Langtext = $"Von {Mitarbeiter.Username} zur Teillieferung freigegeben";
                pos.LangtextDrucken = false;
                pos.PosOhneDruck = true;
                try
                {
                    await belegService.CreatePositionAsync(pos, BelegTyp.Auftrag, true, fbController);

                    await freigabeService.AuftragFreigebenAysnc(_auftrag.Belegnummer, DateTime.Now, fbController);

                    await AddAlertAsync(new AlertBox
                    {
                        AlertType = AlertType.Success,
                        Message = $"Auftrag {Auftragsnummer} wurde erfolgreich freigegeben.",
                        DecayTime = 10
                    });
                }
                catch (Exception ex)
                {
                    Console.WriteLine(ex);
                    Console.ReadKey();
                }
            }
        }
    }
}
