﻿using Microsoft.AspNetCore.Components;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis.Erweiterungen;
using WK5.Core.Models;
using WK5.Core.Services;

namespace WK5_Blazor.Pages.Verkauf.Aufträge
{
    public partial class LimitPrüfung
    {
#nullable disable
        [CascadingParameter] public AppMitarbeiter Mitarbeiter { get; set; }
#nullable enable
        public string FinalBreadcrumbItemName { get; set; } = "Kreditlimit Prüfung";
        public string ActivePageName { get; set; } = "Kreditlimit Prüfung";

        public List<Auftrag> Aufträge { get; set; } = new List<Auftrag>();
        public List<Kunde> Kunden { get; set; } = new List<Kunde>();
        protected override async Task OnParametersSetAsync()
        {
            using FbController2 fbController = new FbController2();            
            Kunden.Clear();
            Aufträge = await belegService.GetLimitPrüfungsAufträge(fbController).ToListAsync();

            foreach (Auftrag au in Aufträge)
            {
                if (!Kunden.Where(x => x.KUND_A_NR.Equals(au.Kundennummer)).Any())
                {
                    var kunde = await Kunde.GetKundeAsync(au.Kundennummer);
                    if (kunde is not null)
                    {
                        Kunden.Add(kunde);
                    }
                }
            }

        }

        private async Task AuftragKreditlimitFreigeben(Auftrag auftrag)
        {
            using FbController2 fbController = new FbController2(Mitarbeiter.PersonalNummer);                                    
            fbController.AddParameter("@BELENR", auftrag.Belegnummer);
            await fbController.QueryAsync("UPDATE BELEGE SET WK5_BELE_L_LIMITPRUEFUNG = 'N' WHERE BELE_A_TYP = 'AU' AND BELE_N_NR = @BELENR");
            await jsRuntime.ShowToast(ToastType.success, "Auftrag wurde erfolgreich aus der Kreditlimit Prüfung freigegeben");
            Aufträge.Remove(auftrag);            
        }
    }
}
