﻿using Microsoft.AspNetCore.Components.Forms;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis;
using WK5.Core.Basis.Erweiterungen;
using WK5.Core.Models;

namespace WK5_Blazor.Pages.Tools
{
    public partial class ZubehörImport
    {
        public Artikel? SelectedArtikel { get; set; }

        private bool _showArtikelSuche = false;
        public List<string> ZubehörArtikel { get; set; } = new List<string>();
        private bool _gesperrt = false;
        private async Task HandleFileSelected(InputFileChangeEventArgs e)
        {
            ZubehörArtikel.Clear();
            _gesperrt = true;
            await InvokeAsync(StateHasChanged);
            List<IBrowserFile> files = new List<IBrowserFile>();
            if (e.FileCount > 1)
            {
                files.AddRange(e.GetMultipleFiles());
            }
            else
            {
                files.Add(e.File);
            }

            foreach (IBrowserFile file in files)
            {
                
                byte[] data = await CoreExtensions.BrowserFileExtension.ToArray(file);


                string content = Encoding.UTF8.GetString(data);
                using StringReader reader = new StringReader(content);
                string? line;
                while ((line = reader.ReadLine()) != null)
                {
                    if (!String.IsNullOrWhiteSpace(line) && !ZubehörArtikel.Contains(line))
                        ZubehörArtikel.Add(line.Trim());
                }
            }
            _gesperrt = false;
        }

        private async Task ZubehörArtikelHinzufügen()
        {
            if (SelectedArtikel is null)
            {
                await AddAlertAsync(new AlertBox
                {
                    AlertType = AlertType.Danger,
                    Message = "Es muss ein Hauptartikel ausgewählt werden",
                    DecayTime = 5
                });                
            }
            else
            {
                _gesperrt = true;
                await InvokeAsync(StateHasChanged);
                using FbController2 fbController = new FbController2();
                foreach (string artikel in ZubehörArtikel)
                {
                    try
                    {
                        await new ArtikelZubehör
                        {
                            ARZU_A_AUSGANGSART = SelectedArtikel.Artikelnummer,
                            ARZU_A_ZUBEHOERART = artikel
                        }.CreateAsync(fbController);
                    }
                    catch (Exception)
                    {
                        fbController.ClearParameters();
                    }
                    
                }

                await AddAlertAsync(new AlertBox
                {
                    AlertType = AlertType.Success,
                    Message = "Artikel wurden erfolgreich als Zubehör hinzugefügt",
                    DecayTime = 5

                });
                _gesperrt = false;
            }

            await SetAlerts();
        }
    }
}
