﻿using Microsoft.AspNetCore.Components;
using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis.Erweiterungen;
using WK5.Core.Models;
using WK5.Core.PageModels;
using WK5.Core.PageModels.Tools.SNSwitcher;

namespace WK5_Blazor.Pages.Tools
{
    public partial class SnSwitcher : ITabView<SelectedSnTab>
    {
#nullable disable
        [CascadingParameter] public AppMitarbeiter Mitarbeiter { get; set; }
#nullable enable
        public SNSwitcherBelegInput BelegInput { get; set; } = new SNSwitcherBelegInput();
        public SNSwitcherFullInput FullInput { get; set; } = new SNSwitcherFullInput();

        public Dictionary<int, string> ExistingSn { get; set; } = new Dictionary<int, string>();

        public List<string> ErsatzSn { get; set; } = new List<string>();

        public SelectedSnTab ActiveTab { get; set; } = SelectedSnTab.Beleg;

        public async Task ChangeBelegSeriennummer()
        {
            BelegSeriennummer? bsn = await BelegSeriennummer.GetBelegSeriennummerAsync(BelegInput.AlteSeriennummer);
            if (bsn is not null && !String.IsNullOrWhiteSpace(BelegInput.NeueSeriennummer))
            {
                (bool success, string message) result = await SNSwitcher.ChangeBelegSn(bsn.BSNR_A_SN, BelegInput.NeueSeriennummer, BelegInput.BelegTyp, BelegInput.Belegnummer, chargenService);
                if (result.success)
                {
                    await jsRuntime.ShowSweetAlert2("Erfolg", result.message, SweetAlertMessageType.success);
                }
                else
                {
                    await jsRuntime.ShowSweetAlert2("Fehler", result.message, SweetAlertMessageType.error);
                }
            }


        }

        public async Task LoadExistingBelegSn()
        {
            ExistingSn.Clear();
            using FbController2 fbController = new FbController2();
            await foreach (BelegSeriennummer bsn in BelegSeriennummer.GetBelegSeriennummernAsync(BelegInput.BelegTyp, BelegInput.Belegnummer, fbController))
            {
                if (bsn is not null)
                {
                    ExistingSn.Add(bsn.BSNR_N_ID, bsn.BSNR_A_SN ?? "");
                    StateHasChanged();
                }
            }
        }

        public async Task LoadErsatzSn()
        {
            ErsatzSn.Clear();
            if (BelegInput.AlteSeriennummer > 0)
            {
                BelegSeriennummer? bsn = await BelegSeriennummer.GetBelegSeriennummerAsync(BelegInput.AlteSeriennummer);
                if (bsn is not null)
                {
                    using FbController2 fbController = new FbController2();
                    Charge? charge = await Charge.GetChargeAsync(bsn.BSNR_N_CHARGE, fbController);
                    if (charge is not null)
                    {
                        await foreach (Seriennummer sn in Seriennummer.FindeOffeneSeriennummernByArtikelAsync(charge.CHAR_A_ARTINR))
                        {
                            ErsatzSn.Add(sn.Nummer);
                            StateHasChanged();
                        }

                    }
                }

            }
        }



        public async Task ChangeFullSeriennummer()
        {
            bool success = await SNSwitcher.Change(FullInput.AlteSeriennummer, FullInput.NeueSeriennummer);
            if (success)
            {
                await jsRuntime.ShowSweetAlert2("Erfolg", "Die Seriennummer wurde erfolgreich geändert", SweetAlertMessageType.success);
            }
            else
            {
                await jsRuntime.ShowSweetAlert2("Fehler", "Die Seriennummer konnte nicht geändert werden", SweetAlertMessageType.error);
            }
        }

        public string GetNavListClass(bool isActive) => isActive ? "nav-link active edit-page-nav-link" : "nav-link edit-page-nav-link";
        public string GetTabClass(bool isActive) => isActive ? "tab-pane fade active show" : "tab-pane fade d-none";


    }
}
