using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Components;
using Microsoft.AspNetCore.Components.Forms;
using WK5.Core;
using WK5.Core.Basis.Erweiterungen;
using WK5.Core.Models;
using WK5.Core.Services;

namespace WK5_Blazor.Pages.Tools
{
    public partial class PreislistenImport
    {
        private bool _isImporting;
        private bool _isLoading;
        private int _fortschritt;
        private List<PreislistenImportArtikel> _fehlerBeiImport = new List<PreislistenImportArtikel>();
#nullable disable
        [CascadingParameter] public AppMitarbeiter Mitarbeiter { get; set; }
#nullable enable


        private Task OnIndexChangedAsync(int index, ColumnZuordnung zuordnung)
        {
            _isLoading = true;
            StateHasChanged();
            zuordnung.ZuordnungsIndex = index;
            foreach (var item in preislistenImportService.ZuordnungColumns)
            {
                if (item != zuordnung)
                {
                    if (item.ZuordnungsIndex == zuordnung.ZuordnungsIndex)
                    {
                        item.ZuordnungsIndex = -1;
                    }
                }
            }

            if (preislistenImportService.ZuordnungColumns.Any(x => x.IsArtikelnummerColumn) && preislistenImportService.ZuordnungColumns.Any(x => x.IsPreisColumn) && preislistenImportService.ZuordnungColumns.Any(x => x.IsHndlerPreisColumn))
            {
                preislistenImportService.ClearWrongFormattedRows();
            }
            _isLoading = false;
            return Task.CompletedTask;
        }

        private async Task OnUploadAsync(InputFileChangeEventArgs e)
        {
            _isLoading = true;
            await preislistenImportService.ReadFileAsync(e.File);
            _isLoading = false;
        }

        private async Task ImportiereAsync()
        {
            ShowAlerts.Clear();
            if(!preislistenImportService.ZuordnungColumns.Any(x => x.IsPreisColumn) || !preislistenImportService.ZuordnungColumns.Any(x => x.IsArtikelnummerColumn) || !preislistenImportService.ZuordnungColumns.Any(x => x.IsHndlerPreisColumn))
            {
                ShowAlerts.Add(new WK5.Core.Basis.AlertBox("Preis, Artikelnummer & Hndlerpreis mssen festgelegt werden!", WK5.Core.Basis.AlertType.Danger));                
                return;
            }

            _isImporting = true;
            _fortschritt = 0;
            _fehlerBeiImport.Clear();
            using FbController2 fbController = new FbController2(Mitarbeiter.PersonalNummer);
            foreach (var import in preislistenImportService.GetImportArtikel())
            {
                bool result = await preislistenImportService.ImportiereAsync(import, fbController);
                if(!result)
                {
                    _fehlerBeiImport.Add(import);
                }
                _fortschritt++;
                StateHasChanged();
            }

            _isImporting = false;
            await jsRuntime.ShowToast(ToastType.success, "Import erfolgreich abgeschlossen!");
        }
    
        private Task LieferantSelectedAsync(Lieferant? lieferant)
        {
            preislistenImportService.SelectedLieferant = lieferant;
            return Task.CompletedTask;
        }

        private bool IsArtikelColumn(int index)
        {
            var column = preislistenImportService.ZuordnungColumns.FirstOrDefault(x => x.IsArtikelnummerColumn);

            if(column is null)
            {
                return false;
            }

            return column.ZuordnungsIndex is 0 && index == column.Index;

        }

        private Task OnLieferantSucheModalClosedAsync()
        {
            if(preislistenImportService.SelectedLieferant is null)
            {
                navigationManager.NavigateTo("/");
            }

            return Task.CompletedTask;
        }
    }
}