﻿using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis;
using WK5_Blazor.PageModels.Tools;

namespace WK5_Blazor.Pages.Tools
{
    public partial class PaketnummerFinder
    {
        private AlertBox? _hinweis = null;
        private PaketnummerFinderInput Input { get; set; } = new PaketnummerFinderInput();
        private async Task FindBelegAsync()
        {
            using FbController2 fbController = new FbController2();
            // Test SQL: SELECT BELE_A_TYP, BELE_N_NR,BELE_N_FRACHTEK, BELE_N_FRACHTVK FROM BELEGE WHERE (BELE_A_TYP = 'RE' AND BELE_N_NR = 37971) OR (BELE_A_TYP = 'AU' AND BELE_N_NR = 37373) OR (BELE_A_TYP = 'LS' AND BELE_N_NR = 38315) 
            fbController.AddParameter("@PAKETNUMMER", Input.Paketnummer);
            var row = await fbController.SelectRowAsync(@"SELECT PAKE_N_BELENR, PAKE_A_TYP, BELE_N_FRACHTVK FROM PAKETE P INNER JOIN BELEGE B ON (P.PAKE_N_BELENR = B.BELE_N_NR AND P.PAKE_A_TYP = B.BELE_A_TYP) WHERE PAKE_A_NR = @PAKETNUMMER");

            if (row == null)
            {
                _hinweis = new AlertBox
                {
                    AlertType = AlertType.Danger,
                    Message = $"Für die Paketnummer {Input.Paketnummer} konnte kein Beleg gefunden werden."
                };
            }
            else
            {
                _hinweis = new AlertBox
                {
                    AlertType = AlertType.Success,
                    Message = $"Beleg {row["PAKE_A_TYP"]}-{row["PAKE_N_BELENR"]} gefunden."
                };
            }
        }
    }
}
