﻿using KarleyLibrary.Attributes;
using KarleyLibrary.Erweiterungen;
using Microsoft.AspNetCore.Components.Forms;
using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis.Erweiterungen;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;
using WK5_Blazor.CoreExtensions;

namespace WK5_Blazor.Pages.Tools
{
    public class Paketzuordnung
    {
        public W4Paket? LokalPaket { get; set; }
        public MBECSV MbePaket { get; set; }
    }

    public partial class MBEPaketPrüfung
    {
        public List<Paketzuordnung> ShowPakete { get; set; } = new List<Paketzuordnung>();
        public IBrowserFile? SelectedFile { get; set; }

        private bool _gesperrt = false;

        public MbePaketPrüfungFilter Filter { get; set; } = new MbePaketPrüfungFilter();


        private async Task HandleFileSelected(InputFileChangeEventArgs e)
        {
            _gesperrt = true;
            await InvokeAsync(StateHasChanged);
            List<IBrowserFile> files = new List<IBrowserFile>();
            if (e.FileCount > 1)
            {
                files.AddRange(e.GetMultipleFiles());
            }
            else
            {
                files.Add(e.File);
            }

            SelectedFile = files.FirstOrDefault();
            _gesperrt = false;
        }

        public async Task Auswerten()
        {
            if(SelectedFile is null)
            {
                await jsRuntime.ShowToast(ToastType.error, "Es muss eine Datei ausgewählt werden!");
                _showHilfeModal = true;
                return;
            }

            _gesperrt = true;
            await InvokeAsync(StateHasChanged);

            
            byte[] data = await BrowserFileExtension.ToArray(SelectedFile);

            string content = Encoding.UTF8.GetString(data);
            using StringReader reader = new StringReader(content);
            List<MBECSV> mbeData = CSVReader.Read<MBECSV>(reader, ';').ToList();
            await Search(mbeData);

            _gesperrt = false;            
        }
        public bool _showHilfeModal = false;
        public async Task Search(List<MBECSV> mbeCsvData)
        {
            ShowPakete.Clear();
            using FbController2 fbController = new FbController2();

            string sql = "SELECT * FROM PAKETE WHERE CAST(PAKE_T_DATUM as date) >= @VON AND cast(PAKE_T_DATUM as date) <= @BIS";

            fbController.AddParameter("@VON", Filter.Von.ToShortDateString());
            fbController.AddParameter("@BIS", Filter.Bis.ToShortDateString());

            DataTable data = await fbController.SelectDataAsync(sql);
            List<W4Paket> existierendePakete = new List<W4Paket>();
            foreach (DataRow row in data.Rows)
            {
                existierendePakete.Add(ObjectErweiterung.DataRowZuObjekt(new W4Paket(), row));
            }

            foreach (MBECSV csv in mbeCsvData)
            {
                W4Paket? pak = existierendePakete.Where(x => (x.PAKE_A_NR ?? String.Empty).Equals(csv.Trackingnummer, StringComparison.OrdinalIgnoreCase)).FirstOrDefault();
                if (pak is null)
                {
                    ShowPakete.Add(new Paketzuordnung { MbePaket = csv });
                }
                else
                {
                    if (pak.PAKE_N_GEWICHT < csv.KurierRealgewicht)
                    {
                        ShowPakete.Add(new Paketzuordnung { MbePaket = csv, LokalPaket = pak });
                        continue;
                    }
                }
            }
        }

    }

    public class MBECSV
    {
        [CompareField("YourMbeId")]
        public int YourMbeId { get; set; }

        [CompareField("Sendungsnummer")]
        public int Sendungsnummer { get; set; }

        [CompareField("Empfängeradresse: Firmenname")]
        public string EmpfängerFirma { get; set; } = string.Empty;


        [CompareField("Empfängeradresse:  Straße")]
        public string EmpfängerStraße { get; set; } = string.Empty;


        [CompareField("Empfängeradresse: Abteilung")]
        public string EmpfängerAbteilung { get; set; } = string.Empty;


        [CompareField("Empfängeradresse: Raum/Etage")]
        public string EmpfängerEtage { get; set; } = string.Empty;


        [CompareField("Empfängeradresse: Stadt")]
        public string EmpfängerStadt { get; set; } = string.Empty;


        [CompareField("Empfängeradresse: Bundesland")]
        public string EmpfängerBundesland { get; set; } = string.Empty;


        [CompareField("Empfängeradresse: Postleitzahl")]
        public string EmpfängerPostleitzahl { get; set; } = string.Empty;


        [CompareField("Empfängeradresse: Länder ID")]
        public int EmpfängerLandId { get; set; }


        [CompareField("Empfängeradresse: Telefon")]
        public string EmpfängerTelefon { get; set; } = string.Empty;


        [CompareField("Empfängeradresse: Faxnummer")]
        public string EmpfängerFax { get; set; } = string.Empty;


        [CompareField("Empfängeradresse: Email 1")]
        public string EmfpängerEmail1 { get; set; } = string.Empty;


        [CompareField("Kuriername")]
        public string Kuriername { get; set; } = string.Empty;


        [CompareField("Kurierpacktyp")]
        public string Kurierpacktyp { get; set; } = string.Empty;


        [CompareField("Kurier-Realgewicht")]
        public decimal KurierRealgewicht { get; set; }


        [CompareField("Kurier-Volumengewicht")]
        public decimal KurierVolumengewicht { get; set; }


        [CompareField("Kunden-Realgewicht")]
        public decimal KundenRealgewicht { get; set; }


        [CompareField("Kunden-Volumengewicht")]
        public decimal KundenVolumengewicht { get; set; }


        [CompareField("Höhe")]
        public decimal Höhe { get; set; }


        [CompareField("Breite")]
        public decimal Breite { get; set; }


        [CompareField("Tiefe")]
        public decimal Tiefe { get; set; }


        [CompareField("Empfängeradresse: Kontaktname")]
        public string EmpfängerKontaktname { get; set; } = string.Empty;


        [CompareField("MBE Trackingnummer")]
        public string MBETrackingnummer { get; set; } = string.Empty;


        [CompareField("Warenbeschreibung")]
        public string Warenbeschreibung { get; set; } = string.Empty;


        [CompareField("Bezug")]
        public string Bezug { get; set; } = string.Empty;


        [CompareField("Bemerkung")]
        public string Bemerkung { get; set; } = string.Empty;


        [CompareField("InternalNote")]
        public string InternalNote { get; set; } = string.Empty;


        [CompareField("Samstagzustellung")]
        public bool Samstagzustellung { get; set; }


        [CompareField("Nachnahme: Wert")]
        public decimal NachnahmeWert { get; set; }


        [CompareField("Art der Nachnahme: 0=keine; 1=Bar; 2=Scheck")]
        public int ArtDerNachnahme { get; set; }


        [CompareField("Haftung: Wert")]
        public decimal HaftungWert { get; set; }


        [CompareField("PredictSms")]
        public bool PredictSms { get; set; }


        [CompareField("PredictEmail")]
        public bool PredictEmail { get; set; }


        [CompareField("Trackingnummer")]
        public string Trackingnummer { get; set; } = string.Empty;


        [CompareField("Abteilungs ID")]
        public int AbteilungsID { get; set; }


        [CompareField("Manuelle Sendung")]
        public bool ManuelleSendung { get; set; }


        [CompareField("Sendungsdatum")]
        public DateTime Sendungsdatum { get; set; }


        [CompareField("OnlineMBE WebService Flag")]
        public string OnlineMBEWebServiceFlag { get; set; } = string.Empty;


        [CompareField("Bank Account IBAN")]
        public string BankAccountIBAN { get; set; } = string.Empty;


        [CompareField("Bank Account BIC")]
        public string BankAccountBIC { get; set; } = string.Empty;


        [CompareField("Bank Account Name")]
        public string BankAccountName { get; set; } = string.Empty;


        [CompareField("Signature Required")]
        public string SignatureRequired { get; set; } = string.Empty;


        [CompareField("Absenderadresse: Firmenname")]
        public string AbsenderFirma { get; set; } = string.Empty;


        [CompareField("Absenderadresse: Kontaktname")]
        public string AbsenderKontaktname { get; set; } = string.Empty;


        [CompareField("Absenderadresse:  Straße")]
        public string AbsenderStraße { get; set; } = string.Empty;


        [CompareField("Absenderadresse: Abteilung")]
        public string AbsenderAbteilung { get; set; } = string.Empty;


        [CompareField("Absenderadresse: Raum/Etage")]
        public string AbsenderEtage { get; set; } = string.Empty;


        [CompareField("Absenderadresse: Stadt")]
        public string AbsenderStadt { get; set; } = string.Empty;


        [CompareField("Absenderadresse: Bundesland")]
        public string AbsenderBundesland { get; set; } = string.Empty;


        [CompareField("Absenderadresse: Postleitzahl")]
        public string AbsenderPostleitzahl { get; set; } = string.Empty;


        [CompareField("Absenderadresse: Land")]
        public string AbsenderLand { get; set; } = string.Empty;


        [CompareField("Absenderadresse: Telefon")]
        public string AbsenderTelefon { get; set; } = string.Empty;


        [CompareField("Absenderadresse: Faxnummer")]
        public string AbsenderFax { get; set; } = string.Empty;


        [CompareField("Absenderadresse: Email 1")]
        public string AbsenderEmail1 { get; set; } = string.Empty;


        [CompareField("Sendungstyp")]
        public string Sendungstyp { get; set; } = string.Empty;


    }
}


