﻿using Microsoft.AspNetCore.Components.Web;
using Microsoft.AspNetCore.Mvc;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis;
using WK5.Core.Basis.Erweiterungen;
using WK5.Core.Models;
using WK5.Core.PageModels.Tools.Gewichtsberechner;

namespace WK5_Blazor.Pages.Tools
{
    public partial class GewichtsberechnerForm
    {
        private GewichtsberechnerInput Input = new GewichtsberechnerInput();
        private ManuellGewichtsberechnerInput ManuellerInput = new ManuellGewichtsberechnerInput();


        private bool showShortCutModal;

        private readonly AlertBox zuschlagHinweis = new AlertBox
        {
            AlertType = AlertType.Info,
            Message = "Eventuelle Zuschläge sind bereits im Preis enthalten."
        };

        private Dictionary<string, decimal> shippingOptions = new Dictionary<string, decimal>();

        [BindProperty]
        private int Belegnummer { get; set; }
        [BindProperty]
        private BelegTyp BelegTyp { get; set; } = BelegTyp.Auftrag;
        [BindProperty]
        private bool ManuelleEingabe { get; set; }

        private decimal belegGewicht = 0;
        private Beleg? beleg = null;

        private List<AlertBox> hinweise = new List<AlertBox>();
        private bool lädtDaten = false;
        private bool gesperrt = false;

        private async Task OnBelegnummerFocusOut(FocusEventArgs e)
        {
            beleg = null;
            belegGewicht = -1;
            gesperrt = false;
            using FbController2 fbController = new FbController2();
            beleg = await Beleg.GetBelegAsync(BelegTyp, Belegnummer, fbController);


            if (beleg is not null)
            {
                hinweise.Clear();
                var recipient = await beleg.ToRecipientTypeAsync(fbController);
                Input.DestinationInfo.City = recipient.City;
                Input.DestinationInfo.Country = recipient.Country;
                Input.DestinationInfo.ZipCode = recipient.ZipCode;
                belegGewicht = beleg.GetBelegGewicht();

                Kunde kunde = await Kunde.GetKundeAsync(beleg.Kundennummer) ?? throw new ArgumentNullException(nameof(kunde));

                if (kunde.KUND_WK5_L_VERSANDWARNUNG)
                {
                    hinweise.Add(new AlertBox
                    {
                        AlertType = AlertType.Warning,
                        Message = "ACHTUNG! Berechnung der Versandkosten ist mit dem Gewichtsberechner nicht möglich. Bitte die Preise manuell bei <a href='https://onlinembe.de' target='_blank' class='alert-link'>OnlineMbe</a> abfragen."
                    });
                    gesperrt = true;
                }

                if (beleg.GetNetto(Program.AppDaten.Optionen) >= 1000 
                    && Program.AppDaten.Länder.Any(x => !x.WK5_LAND_L_ISTEULAND && x.LAND_A_ID == Input.DestinationInfo.Country) 
                    && Input.DestinationInfo.Country != "DE")
                {
                    hinweise.Add(new AlertBox
                    {
                        AlertType = AlertType.Warning,
                        Message = "ACHTUNG! +3 Tage Lieferzeit aufgrund von Lieferung in Drittland. Wurde der Kunde darüber informiert?"
                    });
                }
            }
        }
        private async Task PreiseBerechnen()
        {
            lädtDaten = true;
            StateHasChanged();
            shippingOptions.Clear();
            shippingOptions = await versandService.GetShippingOptionsAsync(Input.Pakete, Input.DestinationInfo, beleg?.GetNettoBetrag(Program.AppDaten.Optionen) ?? 0, Program.AppDaten.Länder, jsRuntime);

            lädtDaten = false;
        }
    }
}
