﻿using Microsoft.AspNetCore.Components;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis.Erweiterungen;
using WK5.Core.Basis.Filter;
using WK5.Core.Drucken.Briefe;
using WK5.Core.Drucken.Zeiterfassungen;
using WK5.Core.Models;

namespace WK5_Blazor.Pages.Tools
{
    public partial class AuswertungZeiterfassung : IAsyncDisposable
    {
        public ZeitenFilter Filter { get; set; } = new ZeitenFilter()
        {
            AusschließlichZeitenDieBerechnetWerden = true,
            NurAbzurechnendeLeistungen = true,
            Option = ZeitenFilterOption.Kunde
        };

#nullable disable
        [CascadingParameter]
        public AppMitarbeiter Mitarbeiter { get; set; }
#nullable enable

        private CancellationTokenSource _cts = new CancellationTokenSource();
        private List<(string kundennummer, string kundenname, long minuten)> _results = new ();
        private bool _lädt;
        private bool _isDownloading;
        private string? _kundennummerAbrechnen;
        private string? _kundennameAbrechnen;
        protected override async Task OnInitializedAsync()
        {
            await LadeAsync();
        }
        private async Task LadeAsync()
        {
            _cts.Cancel();
            _cts.Dispose();
            _cts = new CancellationTokenSource();
            var token = _cts.Token;
            _results.Clear();
            _lädt = true;
            using FbController2 fbController = new FbController2();
            await foreach (var item in zeiterfassungService.GetAuswertungÜbersichtAsync(Filter, fbController, token))
            {
                _results.Add(item);
                StateHasChanged();
            }

            _lädt = false;

        }

        private async Task DownloadAsync(string kundennummer)
        {
            _isDownloading = true;
            ZeitenFilter filter = new ZeitenFilter
            {
                IgnoreOption = true,
                Kundennummer = kundennummer,
                Suchbegriff = kundennummer,
                AusschließlichZeitenDieBerechnetWerden = Filter.AusschließlichZeitenDieBerechnetWerden,
                Option = ZeitenFilterOption.Kunde,
                ZeitraumEingrenzen = true,
                Zeitraum = (Zeitraum)Filter.Zeitraum.Clone()
            };

            using FbController2 fbController = new FbController2();

            List<Zeiterfassung> zeiten = await zeiterfassungService.GetZeitenAsync(filter, fbController).ToListAsync();

            BriefRegelsatz regeln = new BriefRegelsatz
            {
                ShowHeader = true,
                ShowFooter = true
            };

            PrintZeiterfassung printer = await PrintZeiterfassung.CreateAsync(zeiten, regeln, kundennummer, filter.Zeitraum.Von, filter.Zeitraum.Bis, Program.AppDaten.Mitarbeiter, fbController);
            string filenamePdf = printer.Print(GlobalConfig.Configuration.OutputPfad);
            await downloadService.DownloadFile(Path.GetFileName(filenamePdf), await File.ReadAllBytesAsync(filenamePdf), "application/pdf");
            await downloadService.ClearBuffers();

            _isDownloading = false;
        }
        
        private async Task KundennummerAbrechnenAsync()
        {
            if (!string.IsNullOrWhiteSpace(_kundennummerAbrechnen))
            {
                using FbController2 fbController = new FbController2(Mitarbeiter.PersonalNummer);
                await zeiterfassungService.ZeitenAbrechnenAsync(Filter, _kundennummerAbrechnen, fbController);
                await jsRuntime.ShowToast(ToastType.success, "Zeiten wurden erfolgreich abgerechnet");
            }
        }
        public ValueTask DisposeAsync()
        {
            _cts.Cancel();
            _cts.Dispose();
            return ValueTask.CompletedTask;
        }

    }
}
