﻿using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core.Models;
using WK5.Core.Models.Statistik;
using WK5.Core.PageModels.Tools.Statistik;

namespace WK5_Blazor.Pages.Statistik.Verkauf
{
    public partial class VerkaufNachWarengruppe
    {
        public VerkaufNachWarengruppeInput Input { get; set; } = new VerkaufNachWarengruppeInput();
        private List<VerkaufNachWarengruppeResult> Ergebnis { get; set; } = new List<VerkaufNachWarengruppeResult>();
        private bool _sperre;
        public async Task Suche()
        {
            _sperre = true;

            var result = await service.VerkaufNachWarengruppe(Input.From, Input.To, Input.Warengruppe, Input.Unterwarengruppe, Input.Limit).ToListAsync();
            result = result.OrderByDescending(x => x.Menge).ToList();

            if (!Input.DisplayNull)
            {
                result = result.Where(x => x.Menge > 0).ToList();
            }

            Ergebnis = result;

            _sperre = false;
        }

        private async Task ErgebnisDrucken()
        {
            if (Ergebnis.Count <= 0)
            {
                return;
            }

            StringBuilder sb = new StringBuilder();
            sb.AppendLine("Artikelnummer;Beschreibung;Menge");
            foreach (VerkaufNachWarengruppeResult res in Ergebnis)
            {
                sb.AppendLine($"{res.Artikelnummer};{res.Beschreibung};{res.Menge}");
            }
            await downloadService.DownloadFileFromText("verkauf-nach-warengruppe.csv", sb.ToString(), Encoding.UTF8,"text/csv");
        }


    }
}
