﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core.Models.Statistik;
using WK5.Core.PageModels.Tools.Statistik;
using WK5.Core.Services;

namespace WK5_Blazor.Pages.Statistik.Verkauf
{
    public partial class KundenOhneVerbrauchsmaterial
    {
        private static List<string> HauptArtikel { get; set; } = new List<string>
        {
            //"074262",
            //"074262D",
            //"LX500E",
            //"LX500EC",
            //"074252",
            //"074412RW",
            //"074412",
            //"074417",
            //"074417RW",
            //"LX910ED",
            //"074456RW",
            //"074456",
            //"074462",
            //"074462RW",
            //"074462RWLW",
            //"074462RWD",
            //"074462D",
            //"VP-700R",
            //"VP-700",
            //"VP-700-ONLY",
            //"VP-600-D",
            //"VP-600",
            //"VP-600_ONLY",
            //"VP750",
            //"VP750-ONLY",
            //"VP2-485STD",
            //"VP2-485BAS",
            //"VP2-485AD",
            //"VP2-485EH",
            //"VP2-495AD",
            //"VP2-495EH",
            //"3500ACETON",
            //"EPS3500D",
            //"EPS3500",
            //"EPS3500-ALT",
            //"EPS3400LT",
            //"EPS3400E",
            //"EPS3400BKE",
            //"EPS3400NU",
            //"EPS3400U",
            //"EPS3400BKU",
        };
        private KundenOhneVerbrauchsmaterialInput Input = new KundenOhneVerbrauchsmaterialInput();
        private bool sperre { get; set; } = false;

        private List<KundenOhneVerbrauchsmaterialResult> Ergebnis { get; set; } = new List<KundenOhneVerbrauchsmaterialResult>();

        public KundenOhneVerbrauchsmaterial()
        {
            HauptArtikel.Sort();
        }

        public async Task Suchen()
        {
            sperre = true;

            DateTime datum = DateTime.Now.AddMonths(-Input.Monate);

            var result = await service.KundenOhneVerbrauchsmaterialAsync(datum, Input.Artikel);
            Ergebnis = result.OrderByDescending(x => x.BELE_D_DATE).ToList();



            sperre = false;
        }

        private async Task ErgebnisDrucken()
        {
            if (Ergebnis.Count <= 0)
            {
                return;
            }

            StringBuilder sb = new StringBuilder();
            sb.AppendLine("Kundennummer;Name;Datum");
            foreach (KundenOhneVerbrauchsmaterialResult res in Ergebnis)
            {
                sb.AppendLine($"{res.BELE_A_KUNDENNR};{res.BELE_A_NAME1};{res.BELE_D_DATE.ToShortDateString()}");
            }
            await downloadService.DownloadFileFromText("kunden-ohne-verbrauchsmaterial.csv", sb.ToString(), Encoding.UTF8,"text/csv");
        }

        protected override async Task OnParametersSetAsync()
        {
            HauptArtikel.Clear();
            await foreach (string artinr in artikelService.GetHauptArtikelnummernAsync())
            {
                HauptArtikel.Add(artinr);
                StateHasChanged();
            }
            HauptArtikel = HauptArtikel.OrderBy(x => x).ToList();
            Input.Artikel = HauptArtikel.FirstOrDefault() ?? String.Empty;

        }
    }
}
