﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core.Models;
using WK5.Core.Models.Statistik;
using WK5.Core.PageModels.Tools.Statistik;
namespace WK5_Blazor.Pages.Statistik.Verkauf
{
    public partial class KundenMitVerbrauchsmaterial
    {
        private static List<Artikel> HauptArtikel { get; set; } = new List<Artikel>();
        private KundenMitVerbrauchsmaterialInput Input = new KundenMitVerbrauchsmaterialInput();
        private bool sperre { get; set; } = false;

        private List<KundenMitVerbrauchsmaterialResult> Ergebnis { get; set; } = new List<KundenMitVerbrauchsmaterialResult>();

        public KundenMitVerbrauchsmaterial()
        {

        }

        public async Task Suchen()
        {
            sperre = true;
            StateHasChanged();
            DateTime datum = DateTime.Now.AddMonths(-Input.Monate);

            var result = await service.KundenMitVerbrauchsmaterialsAsync(datum, Input.Artikel).ToListAsync();
            Ergebnis = result.OrderByDescending(x => x.KUND_A_NR).ToList();



            sperre = false;
        }

        private async Task ErgebnisDrucken()
        {
            if (Ergebnis.Count <= 0)
            {
                return;
            }

            StringBuilder sb = new StringBuilder();
            sb.AppendLine("Kundennummer;Name1;Name2;Name3");
            foreach (KundenMitVerbrauchsmaterialResult res in Ergebnis)
            {
                sb.AppendLine($"{res.KUND_A_NR};{res.KUND_A_NAME1};{res.KUND_A_NAME2};{res.KUND_A_NAME2}");
            }
            await downloadService.DownloadFileFromText("kunden-mit-verbrauchsmaterial.csv", sb.ToString(), Encoding.UTF8,"text/csv");
        }

        protected override async Task OnParametersSetAsync()
        {
            HauptArtikel.Clear();
            await foreach (Artikel arti in artikelService.GetHauptArtikelAsync())
            {
                HauptArtikel.Add(arti);
                StateHasChanged();
            }

            HauptArtikel = HauptArtikel.OrderBy(x => x.Artikelnummer).ToList();
            Input.Artikel = HauptArtikel.FirstOrDefault()?.Artikelnummer ?? String.Empty;
        }
    }
}
