﻿using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core.Models.Statistik;
using WK5.Core.PageModels.Tools.Statistik;

namespace WK5_Blazor.Pages.Statistik.Verkauf
{
    public partial class ArtikelNachName
    {
        private bool sperre = false;
        private ArtikelNachNameInput Input { get; set; } = new ArtikelNachNameInput();
        private List<ArtikelNachNameResult> Ergebnis { get; set; } = new List<ArtikelNachNameResult>();

        public async Task Suchen()
        {
            sperre = true;

            Ergebnis.Clear();

            var result = await service.ArtikelNachNameAsync(Input.From, Input.To, Input.Suche, WK5.Core.BelegTyp.Rechnung);

            Ergebnis = result.OrderByDescending(x => x.GesamtVerkauft).ToList();

            sperre = false;
        }

        private async Task ErgebnisDrucken()
        {
            if (Ergebnis.Count <= 0)
            {
                return;
            }

            StringBuilder sb = new StringBuilder();
            sb.AppendLine("Artikelnummer;Bezeichnung;Anzahl verkauft;Zuletzt verkauft");
            foreach (ArtikelNachNameResult res in Ergebnis)
            {
                sb.AppendLine($"{res.Artikelnummer};{res.Bezeichnung};{res.GesamtVerkauft};{res.ZuletztGekauft.ToShortDateString()}");
            }
            await downloadService.DownloadFileFromText("artikel-nach-name.csv", sb.ToString(), Encoding.UTF8,"text/csv");
        }
    }
}
