﻿using Microsoft.AspNetCore.Components.Web;
using System;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;
using WK5.Core.PageModels.Tools.Statistik;

namespace WK5_Blazor.Pages.Statistik.Verkauf
{
    public partial class ArtikelNachKunde
    {
        private bool showKundenSucheModal { get; set; }
        private Kunde? SelectedKunde { get; set; }
        private bool sperreSuchenButton { get; set; } = false;
        public KundenÜbersichtFilter FilterKunden { get; set; } = new KundenÜbersichtFilter();
        private bool showArtikelSucheModal { get; set; }
        private Artikel? SelectedArtikel { get; set; }
        private int SelectedSuchFeld { get; set; } = -1;

        private ArtikelNachKundeInput Input { get; set; } = new ArtikelNachKundeInput();
        private void KundeSelected(Kunde kunde)
        {
            SelectedKunde = kunde;
            FilterKunden.Suchbegriff = kunde.KUND_A_NR;
            showKundenSucheModal = false;
        }

        private void ArtikelSelected(Artikel artikel)
        {
            Input.Artikel[SelectedSuchFeld].Artikelnummer = artikel.Artikelnummer;
            showArtikelSucheModal = false;
            SelectedSuchFeld = -1;
        }

        private void OnSucheKeyUp(KeyboardEventArgs e)
        {
            if (e.Code == "Enter" || e.Key == "Enter")
            {
                showKundenSucheModal = true;
            }
        }

        private async Task OnSucheChangeAsync()
        {
            if (!String.IsNullOrWhiteSpace(FilterKunden.Suchbegriff))
            {
                Kunde? kunde = await Kunde.GetKundeAsync(FilterKunden.Suchbegriff);
                if (kunde is not null)
                {
                    SelectedKunde = kunde;
                    FilterKunden.Suchbegriff = kunde.KUND_A_NR;
                }

            }
        }

        private async Task Suchen()
        {
            sperreSuchenButton = true;
            if (SelectedKunde != null)
            {
                using FbController2 fbController = new FbController2();


                try
                {
                    await foreach (var (artikelnummer, gekauft) in statistikService.ArtikelNachKundeAsync(SelectedKunde.KUND_A_NR, new Zeitraum(Input.From, Input.To), Input.Artikel.Where(x => !String.IsNullOrWhiteSpace(x.Artikelnummer)).Select(x => x.Artikelnummer).ToList(), fbController, default))
                    {
                        var found = Input.Artikel.FirstOrDefault(x => x.Artikelnummer == artikelnummer);
                        if (found is not null)
                        {
                            found.Menge = gekauft;
                            StateHasChanged();
                        }
                    }
                }
                catch (OperationCanceledException){ }
                
            }
            sperreSuchenButton = false;

        }

        private async Task ErgebnisDrucken()
        {
            if (Input.Artikel.Count <= 0)
            {
                return;
            }

            StringBuilder sb = new StringBuilder();
            sb.AppendLine("Artikelnummer;Menge");
            foreach (ArtikelNachKunde_ArtikelInput res in Input.Artikel)
            {
                sb.AppendLine($"{res.Artikelnummer};{res.Menge}");
            }
            await downloadService.DownloadFileFromText("artikel-nach-kunde.csv", sb.ToString(), Encoding.UTF8,"text/csv");
        }
    }

}
