using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Components;
using System.Net.Http;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Components.Authorization;
using Microsoft.AspNetCore.Components.Forms;
using Microsoft.AspNetCore.Components.Routing;
using Microsoft.AspNetCore.Components.Web;
using Microsoft.JSInterop;
using WK5_Blazor;
using WK5_Blazor.Components;
using WK5_Blazor.Components.Lieferanten;
using WK5.Core;
using WK5.Core.Models;
using WK5.Core.Models.Tools.Lagerregal;
using WK5.Core.Models.Tools.AdressReminder;
using WK5.Core.Basis.Erweiterungen;
using WK5.Core.Services;
using WK5_Blazor.Components.Modals;
using WK5.Core.Basis;
using WK5.Core.Models.Versand;
using WK5.Core.PageModels.Tools.Versand;
using WK5_Blazor.PageModels;
using KarleyLibrary.Erweiterungen;
using Microsoft.AspNetCore.Components.Web.Extensions.Head;
using ChartJs.Blazor;
using Radzen;
using Radzen.Blazor;
using BlazorDownloadFile;
using WK5_Blazor.Components.Suchen;
using WK5_Blazor.Authorization;
using Microsoft.AspNetCore.Components.Web.Virtualization;
using WK5.Core.PageModels;
using BlazorWheelZoomLibrary.Shared;
using System.Globalization;
using Microsoft.AspNetCore.Components.Server.ProtectedBrowserStorage;
using Bootstrap;
using WK5.Core.Basis.Filter;
using Toolbelt.Blazor.HotKeys;
using Blazored.FluentValidation;
using WK5.Core.Models.Statistik;
using WK5.Core.Basis.Filter.Statistik;
using System.Threading;
using WK5.Core.Models.Statistik.Umsatzstatistik;

namespace WK5_Blazor.Pages.Statistik.Umsatzstatistik
{
    public partial class GesamtUmsatzProMonat : IAsyncDisposable
    {
        public GesamtUmsatzFilter Filter { get; set; } = new GesamtUmsatzFilter();

        private CancellationTokenSource _cts = new CancellationTokenSource();
        private bool _isLoading;
        public decimal GesamtUmsatzMonat { get; set; }


        [Parameter] public int AuswertungsMonat { get; set; }
        [Parameter] public int AuswertungsJahr { get; set; }

        protected override async Task OnParametersSetAsync()
        {
            // Hier einen neuen Filter deklarieren und aufrufen

            DateTime aktuell = DateTime.Now;
            int AktuellesJahr = DateTime.Now.Year;

            if (AuswertungsMonat is > 0 and < 12)
            {
                if (AuswertungsJahr < 2020) //reicht ab da, weil wir die bele_n_netto anders speichern als Delling - vorher also nicht okay)
                    AuswertungsJahr = AktuellesJahr;

                DateTime letzerMonat = new DateTime(AuswertungsJahr, AuswertungsMonat, 1);

                Filter.Von = new DateTime(letzerMonat.Year, letzerMonat.Month, 1);
                Filter.Bis = new DateTime(letzerMonat.Year, letzerMonat.Month, DateTime.DaysInMonth(letzerMonat.Year, letzerMonat.Month));

                await LadeAsync();
            }
        }

        //So bekommt man einen User an jeder Seite bertragen:
        // #nullable disable
        // [CascadingParameter] public AppMitarbeiter Mitarbeiter { get; set; }
        // #nullable enable

        protected override async Task OnInitializedAsync()
        {
            await LadeAsync();
        }

        private async Task LadeAsync()
        {
            //Damit der Kram nicht unendlich weiter ldt und abgebrochen werden kann:
            _cts.Cancel();
            _cts.Dispose();
            _cts = new CancellationTokenSource();

            //Immer hier den Token definieren, nicht in der bergabe, sonst strzt es ab.
            var token = _cts.Token;

            //Nur wenn mehrere Daten und man wartet, werden diese einzeln eingeladen
            _isLoading = true;

            //FBController nur mit Using, sonst bleibt der unendlich offen - DB Last.
            //Im FBController ist die Nummer schon drin, ID bergeben z.B.
            // using FbController2 fbController = new FbController2(Mitarbeiter.Personalnummer);

            using FbController2 fbController = new FbController2();
            try
            {
                //mit F12 definieren
                GesamtUmsatzMonat = await statistikService.GetGesamtUmsatzAsync(Filter, fbController, token);
            }
            catch (OperationCanceledException) { }
            finally
            {
                _isLoading = false;
            }

        }

        public ValueTask DisposeAsync()
        {
            _cts.Cancel();
            _cts.Dispose();
            return ValueTask.CompletedTask;
        }

    }
}