﻿using Microsoft.AspNetCore.Components;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;
using WK5.Core.PageModels.Stammdaten.Kunden;
using WK5_Blazor.CoreExtensions;

namespace WK5_Blazor.Pages.Statistik
{
    public partial class KundenkontakteStatistik : IHasPageFilter, IAsyncDisposable
    {
        private CancellationTokenSource _cts = new();
        public Kundenkontakt? _selectedKundenKontakt = null;
        [Parameter] public KundenkontaktFilter Filter { get; set; } = new()
        {
            WiedervorlageZeitraumBegrenzen = true,
            WiedervorlageBis = DateTime.Now,
            WiedervorlageVon = DateTime.Now.AddMonths(-1)
        };


        [Parameter] public bool ShowHeader { get; set; } = true;
        [Parameter] public bool ShowFilter { get; set; } = true;
        [Parameter] public bool ShowWiedervorlageColumn { get; set; } = true;
        [Parameter] public bool ShowWiedervorlageUserColumn { get; set; } = true;

#nullable disable
        [CascadingParameter] public AppMitarbeiter Mitarbeiter { get; set; }
#nullable enable
        public List<Kunde> Kunden { get; set; } = new List<Kunde>();
        public List<Kundenkontakt> Daten { get; set; } = new List<Kundenkontakt>();
        public int TotalItems { get; set; }
        public int Seite { get; set; } = 1;

        protected override async Task OnInitializedAsync()
        {
            Filter.Personal = Mitarbeiter.PersonalNummer;
            await LadeÜbersicht();
        }

        private async Task LadeÜbersicht()
        {
            if (!Mitarbeiter.IsAdmin)
            {
                Filter.Personal = Mitarbeiter.PersonalNummer;
            }


            if ((TotalItems / Filter.Limit) < Seite)
            {
                Seite = 1;
            }

            Filter.Seite = Seite;

            Daten.Clear();
            _cts.Cancel();
            _cts.Dispose();
            _cts = new CancellationTokenSource();
            var token = _cts.Token;
            using FbController2 fbController = new FbController2();
            TotalItems = await kundenkontaktService.GetTotalAmountAsync(Filter, fbController, token);
            await foreach (Kundenkontakt kontakt in kundenkontaktService.GetAsync(Filter, fbController, token))
            {
                Daten.Add(kontakt);
                if(!Kunden.Where(x => x.KUND_A_NR.Equals(kontakt.KUKO_A_KUNDNR, StringComparison.OrdinalIgnoreCase)).Any())
                {
                    Kunde? kunde = await Kunde.GetKundeAsync(kontakt.KUKO_A_KUNDNR);
                    if (kunde is not null)
                    {
                        Kunden.Add(kunde);
                    }
                }
                StateHasChanged();
            }
        }
        public Task SelectKundenkontaktAsync(Kundenkontakt kuko)
        {
            _selectedKundenKontakt = kuko;
            return Task.CompletedTask;
        }

        private async Task KundenkontaktErledigenAsync(Kundenkontakt kontakt)
        {
            using FbController2 fbController = new FbController2(Mitarbeiter.PersonalNummer);
            kontakt.KUKO_L_WIEDERV_ERL = true;
            await kundenkontaktService.UpdateAsync(kontakt, fbController);

            if(!Filter.ErledigteAnzeigen)
            {
                Daten.Remove(kontakt);
            }
        }
        public async Task PostKukoEdit()
        {
            _selectedKundenKontakt = null;
            await LadeÜbersicht();
        }

        public ValueTask DisposeAsync()
        {
            _cts?.Cancel();
            _cts?.Dispose();
            return ValueTask.CompletedTask;
        }
    }
}
